/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.path;

import common.Neo4jAlgoTestCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableInt;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.impl.path.ShortestPath;
import org.neo4j.graphalgo.impl.path.TraversalShortestPath;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanderBuilder;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.impl.StandardExpander;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.helpers.collection.Iterables;

public class TestShortestPath
extends Neo4jAlgoTestCase {
    @Test
    public void shouldAbortAsSoonAsPossible() {
        Label A = Label.label((String)"A");
        Label B = Label.label((String)"B");
        Label C = Label.label((String)"C");
        Label D = Label.label((String)"D");
        Label E = Label.label((String)"E");
        Label F = Label.label((String)"F");
        RelationshipType relType = RelationshipType.withName((String)"TO");
        this.recursiveSnowFlake(null, 0, 4, 5, new Label[]{A, B, C, D, E}, relType);
        Node a = (Node)graphDb.findNodes(A).next();
        ResourceIterator allE = graphDb.findNodes(E);
        while (allE.hasNext()) {
            Node e = (Node)allE.next();
            Node f = graphDb.createNode(new Label[]{F});
            f.createRelationshipTo(e, relType);
        }
        CountingPathExpander countingPathExpander = new CountingPathExpander(PathExpanders.forTypeAndDirection((RelationshipType)relType, (Direction)Direction.OUTGOING));
        ShortestPath shortestPath = new ShortestPath(Integer.MAX_VALUE, (PathExpander)countingPathExpander, Integer.MAX_VALUE);
        ResourceIterator allF = graphDb.findNodes(F);
        long start = System.currentTimeMillis();
        while (allF.hasNext()) {
            Node f = (Node)allF.next();
            shortestPath.findAllPaths(a, f);
        }
        long totalTime = System.currentTimeMillis() - start;
        Assert.assertEquals((String)"There are 625 different end nodes. The algorithm should start one traversal for each such node. That is 625*2 visited nodes if traversal is interrupted correctly.", (long)1250L, (long)countingPathExpander.nodesVisited.intValue());
    }

    private void recursiveSnowFlake(Node parent, int level, int desiredLevel, int branchingFactor, Label[] labels, RelationshipType relType) {
        if (level != 0) {
            for (int n = 0; n < branchingFactor; ++n) {
                Node node = graphDb.createNode(new Label[]{labels[level]});
                if (parent != null) {
                    parent.createRelationshipTo(node, relType);
                }
                if (level >= desiredLevel) continue;
                this.recursiveSnowFlake(node, level + 1, desiredLevel, branchingFactor, labels, relType);
            }
        } else {
            Node node = graphDb.createNode(new Label[]{labels[level]});
            this.recursiveSnowFlake(node, level + 1, desiredLevel, branchingFactor, labels, relType);
        }
    }

    @Test
    public void testSimplestGraph() {
        graph.makeEdge("s", "t");
        graph.makeEdge("s", "t");
        this.testShortestPathFinder(finder -> {
            Iterable paths = finder.findAllPaths(graph.getNode("s"), graph.getNode("t"));
            this.assertPaths((Iterable<? extends Path>)paths, "s,t", "s,t");
            this.assertPaths(Arrays.asList(finder.findSinglePath(graph.getNode("s"), graph.getNode("t"))), "s,t");
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.BOTH), 1);
    }

    @Test
    public void testAnotherSimpleGraph() {
        graph.makeEdge("s", "m");
        graph.makeEdge("m", "o");
        graph.makeEdge("s", "n");
        graph.makeEdge("n", "p");
        graph.makeEdge("p", "q");
        graph.makeEdge("q", "t");
        graph.makeEdge("n", "o");
        graph.makeEdge("o", "t");
        this.testShortestPathFinder(finder -> {
            Iterable paths = finder.findAllPaths(graph.getNode("s"), graph.getNode("t"));
            this.assertPaths((Iterable<? extends Path>)paths, "s,m,o,t", "s,n,o,t");
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.BOTH), 6);
    }

    @Test
    public void testCrossedCircle() {
        graph.makeEdge("s", "1");
        graph.makeEdge("s", "3");
        graph.makeEdge("1", "2");
        graph.makeEdge("1", "4");
        graph.makeEdge("3", "2");
        graph.makeEdge("3", "4");
        graph.makeEdge("2", "t");
        graph.makeEdge("4", "t");
        this.testShortestPathFinder(finder -> this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(graph.getNode("s"), graph.getNode("t")), "s,1,2,t", "s,1,4,t", "s,3,2,t", "s,3,4,t"), PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.BOTH), 3);
    }

    @Test
    public void testDirectedFinder() {
        graph.makeEdgeChain("a,b,c,d,e,f,m");
        graph.makeEdgeChain("a,g,h,i,j,k,l,m");
        this.testShortestPathFinder(finder -> this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(graph.getNode("a"), graph.getNode("j")), "a,g,h,i,j"), PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING), 4);
    }

    @Test
    public void makeSureShortestPathsReturnsNoLoops() {
        graph.makeEdgeChain("a,b,c,d,b,c,e");
        this.testShortestPathFinder(finder -> {
            Node a = graph.getNode("a");
            Node e = graph.getNode("e");
            this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(a, e), "a,b,c,e", "a,b,c,e");
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.BOTH), 6);
    }

    @Test
    public void withFilters() throws Exception {
        graph.makeEdgeChain("a,b,c,d");
        graph.makeEdgeChain("a,g,h,d");
        Node a = graph.getNode("a");
        Node d = graph.getNode("d");
        Node b = graph.getNode("b");
        b.setProperty("skip", (Object)true);
        Predicate<Node> filter = item -> {
            boolean skip = (Boolean)item.getProperty("skip", (Object)false);
            return !skip;
        };
        this.testShortestPathFinder(finder -> this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(a, d), "a,g,h,d"), (PathExpander)((StandardExpander)PathExpanders.allTypesAndDirections()).addNodeFilter(filter), 10);
    }

    @Test
    public void filtersTouchesAllIntermediateNodes() throws Exception {
        graph.makeEdgeChain("a,b,c,d");
        Node a = graph.getNode("a");
        Node d = graph.getNode("d");
        HashSet touchedByFilter = new HashSet();
        Predicate<Node> filter = item -> {
            touchedByFilter.add(item);
            return true;
        };
        PathExpander expander = PathExpanderBuilder.empty().add((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, Direction.OUTGOING).addNodeFilter(filter).build();
        Path path = (Path)Iterables.single((Iterable)GraphAlgoFactory.shortestPath((PathExpander)expander, (int)10).findAllPaths(a, d));
        Assert.assertEquals((long)3L, (long)path.length());
        List nodes = Iterables.asList((Iterable)path.nodes());
        List intermediateNodes = nodes.subList(1, nodes.size() - 1);
        Assert.assertTrue((String)("touchedByFilter: " + touchedByFilter), (boolean)touchedByFilter.containsAll(intermediateNodes));
        Assert.assertTrue((String)"startNode was not filtered", (!touchedByFilter.contains(a) ? 1 : 0) != 0);
        Assert.assertTrue((String)"endNode was not filtered", (!touchedByFilter.contains(d) ? 1 : 0) != 0);
    }

    @Test
    public void testFinderShouldNotFindAnythingBeyondLimit() {
        graph.makeEdgeChain("a,b,c,d,e");
        this.testShortestPathFinder(finder -> this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(graph.getNode("a"), graph.getNode("b")), new String[0]), PathExpanders.allTypesAndDirections(), 0);
        this.testShortestPathFinder(finder -> {
            this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(graph.getNode("a"), graph.getNode("c")), new String[0]);
            this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(graph.getNode("a"), graph.getNode("d")), new String[0]);
        }, PathExpanders.allTypesAndDirections(), 1);
        this.testShortestPathFinder(finder -> {
            this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(graph.getNode("a"), graph.getNode("d")), new String[0]);
            this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(graph.getNode("a"), graph.getNode("e")), new String[0]);
        }, PathExpanders.allTypesAndDirections(), 2);
    }

    @Test
    public void makeSureDescentStopsWhenPathIsFound() throws Exception {
        graph.makeEdgeChain("a,b,c,d,e");
        graph.makeEdgeChain("a,b,c,d,e");
        graph.makeEdgeChain("a,f,g,h,i");
        Node a = graph.getNode("a");
        Node b = graph.getNode("b");
        Node c = graph.getNode("c");
        final HashSet<Node> allowedNodes = new HashSet<Node>(Arrays.asList(a, b, c));
        ShortestPath finder = new ShortestPath(100, PathExpanders.forDirection((Direction)Direction.OUTGOING)){

            protected Node filterNextLevelNodes(Node nextNode) {
                if (!allowedNodes.contains(nextNode)) {
                    return null;
                }
                return nextNode;
            }
        };
        Iterator paths = finder.findAllPaths(a, c).iterator();
        for (int i = 0; i < 4; ++i) {
            Path aToBToC = (Path)paths.next();
            this.assertPath(aToBToC, a, b, c);
        }
        Assert.assertFalse((String)"should only have contained four paths", (boolean)paths.hasNext());
    }

    @Test
    public void makeSureRelationshipNotConnectedIssueNotThere() throws Exception {
        graph.makeEdgeChain("i,g,f,e,d,c,b,a");
        graph.makeEdgeChain("i,h,f");
        this.testShortestPathFinder(finder -> {
            Node start = graph.getNode("a");
            Node end = graph.getNode("i");
            this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(start, end), "a,b,c,d,e,f,g,i", "a,b,c,d,e,f,h,i");
        }, PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.INCOMING), 10);
    }

    @Test
    public void makeSureShortestPathCanBeFetchedEvenIfANodeHasLoops() throws Exception {
        graph.makeEdgeChain("m,s,n,p");
        graph.makeEdgeChain("m,o,n");
        graph.makeEdge("o", "o");
        graph.makeEdge("n", "n");
        this.testShortestPathFinder(finder -> this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(graph.getNode("m"), graph.getNode("p")), "m,s,n,p", "m,o,n,p"), PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.BOTH), 3);
    }

    @Test
    public void makeSureAMaxResultCountIsObeyed() {
        graph.makeEdgeChain("a,b,c,d,e");
        graph.makeEdgeChain("a,f,g,h,e");
        graph.makeEdgeChain("f,i,j,e");
        graph.makeEdgeChain("i,k,e");
        Node a = graph.getNode("a");
        Node e = graph.getNode("e");
        PathExpander expander = PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING);
        this.testShortestPathFinder(finder -> Assert.assertEquals((long)4L, (long)Iterables.count((Iterable)finder.findAllPaths(a, e))), expander, 10, 10);
        int i = 4;
        while (i >= 1) {
            int count = i--;
            this.testShortestPathFinder(finder -> Assert.assertEquals((long)count, (long)Iterables.count((Iterable)finder.findAllPaths(a, e))), expander, 10, count);
        }
    }

    @Test
    public void unfortunateRelationshipOrderingInTriangle() {
        graph.makeEdgeChain("a,b,c");
        graph.makeEdgeChain("a,c");
        Node a = graph.getNode("a");
        Node c = graph.getNode("c");
        this.testShortestPathFinder(finder -> this.assertPathDef(finder.findSinglePath(a, c), "a", "c"), PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING), 2);
        this.testShortestPathFinder(finder -> this.assertPathDef(finder.findSinglePath(c, a), "c", "a"), PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.INCOMING), 2);
    }

    @Test
    public void shouldFindShortestPathWhenOneSideFindsLongerPathFirst() throws Exception {
        graph.makeEdge("start", "c");
        graph.makeEdge("start", "a");
        graph.makeEdge("b", "end");
        graph.makeEdge("d", "end");
        graph.makeEdge("c", "e");
        graph.makeEdge("f", "end");
        graph.makeEdge("c", "b");
        graph.makeEdge("e", "end");
        graph.makeEdge("a", "end");
        Node start = graph.getNode("start");
        Node end = graph.getNode("end");
        Assert.assertThat((Object)new ShortestPath(2, PathExpanders.allTypesAndDirections(), 42).findSinglePath(start, end).length(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)new ShortestPath(3, PathExpanders.allTypesAndDirections(), 42).findSinglePath(start, end).length(), (Matcher)CoreMatchers.is((Object)2));
    }

    private void testShortestPathFinder(PathFinderTester tester, PathExpander expander, int maxDepth) {
        this.testShortestPathFinder(tester, expander, maxDepth, null);
    }

    private void testShortestPathFinder(PathFinderTester tester, PathExpander expander, int maxDepth, Integer maxResultCount) {
        LengthCheckingExpanderWrapper lengthChecker = new LengthCheckingExpanderWrapper(expander);
        ArrayList<Object> finders = new ArrayList<Object>();
        finders.add(maxResultCount != null ? GraphAlgoFactory.shortestPath((PathExpander)lengthChecker, (int)maxDepth, (int)maxResultCount) : GraphAlgoFactory.shortestPath((PathExpander)lengthChecker, (int)maxDepth));
        finders.add(maxResultCount != null ? new TraversalShortestPath((PathExpander)lengthChecker, maxDepth, maxResultCount.intValue()) : new TraversalShortestPath((PathExpander)lengthChecker, maxDepth));
        for (PathFinder pathFinder : finders) {
            tester.test((PathFinder<Path>)pathFinder);
        }
    }

    private class CountingPathExpander
    implements PathExpander {
        private MutableInt nodesVisited = new MutableInt(0);
        private final PathExpander delegate;

        public CountingPathExpander(PathExpander delegate) {
            this.delegate = delegate;
        }

        public CountingPathExpander(PathExpander delegate, MutableInt nodesVisited) {
            this(delegate);
            this.nodesVisited = nodesVisited;
        }

        public Iterable expand(Path path, BranchState state) {
            this.nodesVisited.increment();
            return this.delegate.expand(path, state);
        }

        public PathExpander reverse() {
            return new CountingPathExpander(this.delegate.reverse(), this.nodesVisited);
        }
    }

    private static class LengthCheckingExpanderWrapper
    implements PathExpander<Object> {
        private final PathExpander expander;

        LengthCheckingExpanderWrapper(PathExpander expander) {
            this.expander = expander;
        }

        public Iterable<Relationship> expand(Path path, BranchState<Object> state) {
            if (path.startNode().equals(path.endNode())) {
                Assert.assertTrue((String)"Path length must be zero", (path.length() == 0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((String)"Path length must be positive", (path.length() > 0 ? 1 : 0) != 0);
            }
            return this.expander.expand(path, state);
        }

        public PathExpander<Object> reverse() {
            return new LengthCheckingExpanderWrapper(this.expander.reverse());
        }
    }

    private static interface PathFinderTester {
        public void test(PathFinder<Path> var1);
    }
}

