/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import java.io.File;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.GraphAlgoFactory;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.path.GeoDataGenerator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

@Ignore(value="Not a test, just nice to have")
public class AStarPerformanceIT {
    private File directory;
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Before
    public void setup() {
        this.directory = this.testDirectory.directory("graph-db");
    }

    @Test
    public void somePerformanceTesting() throws Exception {
        int numberOfNodes = 200000;
        GeoDataGenerator generator = new GeoDataGenerator(numberOfNodes, 5.0, 1000, 1000);
        generator.generate(this.directory);
        long[][] points = new long[][]{{9415L, 158154L}, {89237L, 192863L}, {68072L, 150484L}, {186309L, 194495L}, {152097L, 99289L}, {92150L, 161182L}, {188446L, 115873L}, {85033L, 7772L}, {291L, 86707L}, {188345L, 158468L}};
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.directory.getAbsoluteFile());
        PathFinder algo = GraphAlgoFactory.aStar((PathExpander)PathExpanders.allTypesAndDirections(), (CostEvaluator)CommonEvaluators.doubleCostEvaluator((String)"weight", (double)0.0), GeoDataGenerator.estimateEvaluator());
        for (int i = 0; i < 10; ++i) {
            System.out.println("----- " + i);
            for (long[] p : points) {
                try (Transaction tx = db.beginTx();){
                    Node start = db.getNodeById(p[0]);
                    Node end = db.getNodeById(p[1]);
                    long time = System.currentTimeMillis();
                    WeightedPath path = (WeightedPath)algo.findSinglePath(start, end);
                    time = System.currentTimeMillis() - time;
                    System.out.println("time: " + time + ", len:" + path.length() + ", weight:" + path.weight());
                    tx.success();
                }
            }
        }
        db.shutdown();
    }
}

