/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.path;

import common.Neo4jAlgoTestCase;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.PathFinder;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.path.Dijkstra;
import org.neo4j.graphalgo.impl.path.DijkstraBidirectional;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.NoneStrictMath;

@RunWith(value=Parameterized.class)
public class DijkstraTest
extends Neo4jAlgoTestCase {
    private final DijkstraFactory factory;

    @Test
    public void pathToSelfReturnsZero() {
        Node start = graph.makeNode("A");
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        WeightedPath path = (WeightedPath)finder.findSinglePath(start, start);
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)start, (Object)path.startNode());
        Assert.assertEquals((Object)start, (Object)path.endNode());
        Assert.assertEquals((long)0L, (long)path.length());
    }

    @Test
    public void allPathsToSelfReturnsZero() {
        Node start = graph.makeNode("A");
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        Iterable paths = finder.findAllPaths(start, start);
        for (WeightedPath path : paths) {
            Assert.assertNotNull((Object)path);
            Assert.assertEquals((Object)start, (Object)path.startNode());
            Assert.assertEquals((Object)start, (Object)path.endNode());
            Assert.assertEquals((long)0L, (long)path.length());
        }
    }

    @Test
    public void canFindOrphanGraph() {
        Node nodeA = graph.makeNode("A");
        graph.makeEdge("A", "A", "length", 1.0);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(nodeA, nodeA), "A");
    }

    @Test
    public void canFindNeighbour() {
        Node nodeA = graph.makeNode("A");
        Node nodeB = graph.makeNode("B");
        graph.makeEdge("A", "B", "length", 1);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(nodeA, nodeB), "A,B");
    }

    @Test
    public void canFindNeighbourMultipleCorrectPaths() {
        Node nodeA = graph.makeNode("A");
        Node nodeB = graph.makeNode("B");
        graph.makeEdge("A", "B", "length", 1.0);
        graph.makeEdge("A", "B", "length", 1);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(nodeA, nodeB), "A,B", "A,B");
    }

    @Test
    public void canFindNeighbourMultipleIncorrectPaths() {
        Node nodeA = graph.makeNode("A");
        Node nodeB = graph.makeNode("B");
        graph.makeEdge("A", "B", "length", 2.0);
        graph.makeEdge("A", "B", "length", 1);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        Iterator paths = finder.findAllPaths(nodeA, nodeB).iterator();
        Assert.assertTrue((String)"Expect at least one path", (boolean)paths.hasNext());
        WeightedPath path = (WeightedPath)paths.next();
        this.assertPath((Path)path, nodeA, nodeB);
        Assert.assertTrue((String)"Expect weight 1", (path.weight() == 1.0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Expected at most one path", (boolean)paths.hasNext());
    }

    @Test
    public void canKeepSearchingUntilFoundTrueShortest() {
        Node a = graph.makeNode("A");
        Node b = graph.makeNode("B");
        Node c = graph.makeNode("C");
        Node d = graph.makeNode("D");
        Node e = graph.makeNode("E");
        Node f = graph.makeNode("F");
        Node g = graph.makeNode("G");
        Node h = graph.makeNode("H");
        graph.makeEdgeChain("A,B,C,D,E,F", "length", 1);
        graph.makeEdge("A", "G", "length", 1);
        graph.makeEdge("G", "H", "length", 2);
        graph.makeEdge("H", "F", "length", 1);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        Iterator paths = finder.findAllPaths(a, f).iterator();
        Assert.assertTrue((String)"Expect at least one path", (boolean)paths.hasNext());
        WeightedPath path = (WeightedPath)paths.next();
        this.assertPath((Path)path, a, g, h, f);
        Assert.assertTrue((String)"Expect weight 1", (path.weight() == 4.0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Expected at most one path", (boolean)paths.hasNext());
    }

    @Test
    public void canGetPathsInTriangleGraph() throws Exception {
        Node nodeA = graph.makeNode("A");
        Node nodeB = graph.makeNode("B");
        Node nodeC = graph.makeNode("C");
        graph.makeEdge("A", "B", "length", 2.0);
        graph.makeEdge("B", "C", "length", 3L);
        graph.makeEdge("A", "C", "length", (byte)10);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        Iterator paths = finder.findAllPaths(nodeA, nodeC).iterator();
        Assert.assertTrue((String)"expected at least one path", (boolean)paths.hasNext());
        this.assertPath((Path)paths.next(), nodeA, nodeB, nodeC);
        Assert.assertFalse((String)"expected at most one path", (boolean)paths.hasNext());
        this.assertPath(finder.findSinglePath(nodeA, nodeC), nodeA, nodeB, nodeC);
    }

    @Test
    public void canContinueGettingPathsByDiminishingCost() throws Exception {
        Node nodeA = graph.makeNode("A");
        graph.makeNode("B");
        graph.makeNode("C");
        Node nodeD = graph.makeNode("D");
        graph.makeEdge("A", "B", "length", 2.0);
        graph.makeEdge("B", "C", "length", 3L);
        graph.makeEdge("C", "D", "length", (byte)1);
        graph.makeEdge("B", "D", "length", (short)5);
        graph.makeEdge("A", "D", "length", Float.valueOf(6.0f));
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(nodeA, nodeD), "A,B,C,D", "A,D");
    }

    @Test
    public void canGetMultiplePathsInTriangleGraph() throws Exception {
        Node nodeA = graph.makeNode("A");
        Node nodeB = graph.makeNode("B");
        Node nodeC = graph.makeNode("C");
        HashSet<Relationship> expectedFirsts = new HashSet<Relationship>();
        expectedFirsts.add(graph.makeEdge("A", "B", "length", 1.0));
        expectedFirsts.add(graph.makeEdge("A", "B", "length", 1));
        Relationship expectedSecond = graph.makeEdge("B", "C", "length", 2L);
        graph.makeEdge("A", "C", "length", 5.0);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        Iterator paths = finder.findAllPaths(nodeA, nodeC).iterator();
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue((String)"expected more paths", (boolean)paths.hasNext());
            Path path = (Path)paths.next();
            this.assertPath(path, nodeA, nodeB, nodeC);
            Iterator relationships = path.relationships().iterator();
            Assert.assertTrue((String)"found shorter path than expected", (boolean)relationships.hasNext());
            Assert.assertTrue((String)"path contained unexpected relationship", (boolean)expectedFirsts.remove(relationships.next()));
            Assert.assertTrue((String)"found shorter path than expected", (boolean)relationships.hasNext());
            Assert.assertEquals((Object)expectedSecond, relationships.next());
            Assert.assertFalse((String)"found longer path than expected", (boolean)relationships.hasNext());
        }
        Assert.assertFalse((String)"expected at most two paths", (boolean)paths.hasNext());
    }

    @Test
    public void canGetMultiplePathsInASmallRoadNetwork() throws Exception {
        Node nodeA = graph.makeNode("A");
        Node nodeB = graph.makeNode("B");
        Node nodeC = graph.makeNode("C");
        Node nodeD = graph.makeNode("D");
        Node nodeE = graph.makeNode("E");
        Node nodeF = graph.makeNode("F");
        graph.makeEdge("A", "B", "length", 2.0);
        graph.makeEdge("A", "C", "length", Float.valueOf(2.5f));
        graph.makeEdge("C", "D", "length", 7.3);
        graph.makeEdge("B", "D", "length", Float.valueOf(2.5f));
        graph.makeEdge("D", "E", "length", 3L);
        graph.makeEdge("C", "E", "length", 5);
        graph.makeEdge("E", "F", "length", (byte)5);
        graph.makeEdge("C", "F", "length", (short)12);
        graph.makeEdge("A", "F", "length", 25L);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        for (Node[] nodes : new Node[][]{{nodeA, nodeF}, {nodeF, nodeA}}) {
            int found = 0;
            Iterator paths = finder.findAllPaths(nodes[0], nodes[1]).iterator();
            for (int i = 0; i < 2; ++i) {
                Assert.assertTrue((String)"expected more paths", (boolean)paths.hasNext());
                Path path = (Path)paths.next();
                if (path.length() != found && path.length() == 3) {
                    this.assertContains(path.nodes(), nodeA, nodeC, nodeE, nodeF);
                } else if (path.length() != found && path.length() == 4) {
                    this.assertContains(path.nodes(), nodeA, nodeB, nodeD, nodeE, nodeF);
                } else {
                    Assert.fail((String)("unexpected path length: " + path.length()));
                }
                found = path.length();
            }
            Assert.assertFalse((String)"expected at most two paths", (boolean)paths.hasNext());
        }
    }

    @Test
    public void shouldOnlyFindTheShortestPaths() {
        Node s = graph.makeNode("s");
        Node t = graph.makeNode("t");
        Node a = graph.makeNode("a");
        Node b = graph.makeNode("b");
        Node c = graph.makeNode("c");
        graph.makeEdgeChain("s,e,f", "length", 1.0);
        graph.makeEdge("f", "t", "length", 2);
        graph.makeEdge("s", "a", "length", 2);
        graph.makeEdge("a", "t", "length", 0);
        graph.makeEdge("s", "c", "length", 1);
        graph.makeEdge("c", "d", "length", 1);
        graph.makeEdge("s", "b", "length", 1);
        graph.makeEdge("b", "d", "length", 1);
        graph.makeEdge("d", "a", "length", 0);
        graph.makeEdge("d", "t", "length", 1);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.allTypesAndDirections());
        Iterator paths = finder.findAllPaths(s, t).iterator();
        for (int i = 1; i <= 3; ++i) {
            Assert.assertTrue((String)("Expected at least " + i + " path(s)"), (boolean)paths.hasNext());
            Assert.assertTrue((String)"Expected 3 paths of cost 2", (boolean)NoneStrictMath.equals((double)((WeightedPath)paths.next()).weight(), (double)2.0));
        }
        Assert.assertFalse((String)"Expected exactly 3 paths", (boolean)paths.hasNext());
    }

    private Relationship createGraph(boolean includeOnes) {
        Map propertiesForOnes = includeOnes ? MapUtil.map((Object[])new Object[]{"cost", 1.0}) : MapUtil.map((Object[])new Object[0]);
        graph.makeEdge("start", "a", "cost", 1.0);
        graph.makeEdge("a", "x", "cost", (short)9);
        graph.makeEdge("a", "b", propertiesForOnes);
        graph.makeEdge("b", "x", "cost", 7.0);
        graph.makeEdge("b", "c", propertiesForOnes);
        graph.makeEdge("c", "x", "cost", 5);
        Relationship shortCTOXRelationship = graph.makeEdge("c", "x", "cost", Float.valueOf(3.0f));
        graph.makeEdge("c", "d", propertiesForOnes);
        graph.makeEdge("d", "x", "cost", 3.0);
        graph.makeEdge("d", "e", propertiesForOnes);
        graph.makeEdge("e", "x", propertiesForOnes);
        graph.makeEdge("e", "f", "cost", (byte)2);
        graph.makeEdge("x", "y", "cost", 2.0);
        return shortCTOXRelationship;
    }

    @Test
    public void testSmallGraph() {
        Relationship shortCTOXRelationship = this.createGraph(true);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING), CommonEvaluators.doubleCostEvaluator((String)"cost"));
        Node startNode = graph.getNode("start");
        Node endNode = graph.getNode("x");
        this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(startNode, endNode), "start,a,b,c,x", "start,a,b,c,d,e,x");
        for (WeightedPath path : finder.findAllPaths(startNode, endNode)) {
            if (!this.getPathDef((Path)path).equals("start,a,b,c,x")) continue;
            this.assertContainsRelationship(path, shortCTOXRelationship);
        }
    }

    @Test
    public void testSmallGraphWithDefaults() {
        Relationship shortCTOXRelationship = this.createGraph(true);
        PathFinder<WeightedPath> finder = this.factory.dijkstra(PathExpanders.forTypeAndDirection((RelationshipType)Neo4jAlgoTestCase.MyRelTypes.R1, (Direction)Direction.OUTGOING), CommonEvaluators.doubleCostEvaluator((String)"cost", (double)1.0));
        Node startNode = graph.getNode("start");
        Node endNode = graph.getNode("x");
        this.assertPaths((Iterable<? extends Path>)finder.findAllPaths(startNode, endNode), "start,a,b,c,x", "start,a,b,c,d,e,x");
        for (WeightedPath path : finder.findAllPaths(startNode, endNode)) {
            if (!this.getPathDef((Path)path).equals("start,a,b,c,x")) continue;
            this.assertContainsRelationship(path, shortCTOXRelationship);
        }
    }

    private void assertContainsRelationship(WeightedPath path, Relationship relationship) {
        for (Relationship rel : path.relationships()) {
            if (!rel.equals(relationship)) continue;
            return;
        }
        Assert.fail((String)(path + " should've contained " + relationship));
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new DijkstraFactory(){

            public PathFinder dijkstra(PathExpander expander) {
                return new Dijkstra(expander, CommonEvaluators.doubleCostEvaluator((String)"length"));
            }

            public PathFinder dijkstra(PathExpander expander, CostEvaluator costEvaluator) {
                return new Dijkstra(expander, costEvaluator);
            }
        }}, {new DijkstraFactory(){

            public PathFinder dijkstra(PathExpander expander) {
                return new DijkstraBidirectional(expander, CommonEvaluators.doubleCostEvaluator((String)"length"));
            }

            public PathFinder dijkstra(PathExpander expander, CostEvaluator costEvaluator) {
                return new DijkstraBidirectional(expander, costEvaluator);
            }
        }}, {new DijkstraFactory(){

            @Override
            public PathFinder<WeightedPath> dijkstra(PathExpander expander) {
                return new Dijkstra(expander, InitialBranchState.NO_STATE, CommonEvaluators.doubleCostEvaluator((String)"length"));
            }

            @Override
            public PathFinder<WeightedPath> dijkstra(PathExpander expander, CostEvaluator costEvaluator) {
                return new Dijkstra(expander, InitialBranchState.NO_STATE, costEvaluator);
            }
        }});
    }

    public DijkstraTest(DijkstraFactory factory) {
        this.factory = factory;
    }

    private static interface DijkstraFactory {
        public PathFinder<WeightedPath> dijkstra(PathExpander var1);

        public PathFinder<WeightedPath> dijkstra(PathExpander var1, CostEvaluator var2);
    }
}

