/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphalgo.impl.centrality.ShortestPathBasedCentrality;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.Util;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public class StressCentrality<ShortestPathCostType>
extends ShortestPathBasedCentrality<Double, ShortestPathCostType> {
    protected Double globalFactor;

    public StressCentrality(SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath, Set<Node> nodeSet) {
        super(singleSourceShortestPath, new DoubleAdder(), 0.0, nodeSet);
    }

    @Override
    public void reset() {
        super.reset();
        this.globalFactor = 1.0;
        if (this.singleSourceShortestPath.getDirection().equals((Object)Direction.BOTH)) {
            this.globalFactor = 0.5;
        }
    }

    protected Double getAndUpdateNodeStress(Node node, boolean skipFirstNode, Map<Node, List<Relationship>> successors, Util.PathCounter counter, Map<Node, Double> stresses) {
        Double stress = stresses.get(node);
        if (stress != null) {
            return stress;
        }
        stress = 0.0;
        List<Relationship> succs = successors.get(node);
        if (succs == null || succs.size() == 0) {
            return 0.0;
        }
        for (Relationship relationship : succs) {
            Node otherNode = relationship.getOtherNode(node);
            Double otherStress = this.getAndUpdateNodeStress(otherNode, false, successors, counter, stresses);
            stress = stress + (otherStress + 1.0) * (double)counter.getNumberOfPathsToNode(node);
        }
        if (!skipFirstNode) {
            stresses.put(node, stress);
            this.addCentralityToNode(node, stress * this.globalFactor);
        }
        return stress;
    }

    @Override
    public void processShortestPaths(Node node, SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath) {
        Map<Node, List<Relationship>> predecessors = singleSourceShortestPath.getPredecessors();
        Map<Node, List<Relationship>> successors = Util.reversedPredecessors(predecessors);
        Util.PathCounter counter = new Util.PathCounter(predecessors);
        this.getAndUpdateNodeStress(node, true, successors, counter, new HashMap<Node, Double>());
    }
}

