/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MatrixUtil {
    public static void LUDecomposition(DoubleMatrix matrix) {
        int matrixSize = matrix.size();
        for (int i = 0; i < matrixSize - 1; ++i) {
            double pivot = matrix.get(i, i);
            DoubleVector row = matrix.getRow(i);
            for (int r = i + 1; r < matrixSize; ++r) {
                Double rowStartValue = matrix.get(r, i);
                if (rowStartValue == null || rowStartValue == 0.0) continue;
                double factor = rowStartValue / pivot;
                matrix.set(r, i, factor);
                for (Integer c : row.values.keySet()) {
                    if (c <= i) continue;
                    matrix.incrementValue(r, c, -row.get(c).doubleValue() * factor);
                }
            }
        }
    }

    public static DoubleVector LinearSolve(DoubleMatrix a, DoubleVector b) {
        DoubleVector row;
        int r;
        MatrixUtil.LUDecomposition(a);
        for (r = 0; r < a.size(); ++r) {
            row = a.getRow(r);
            for (Integer c : row.values.keySet()) {
                if (c >= r) continue;
                b.incrementValue(r, -row.get(c).doubleValue() * b.get(c));
            }
        }
        for (r = a.size() - 1; r >= 0; --r) {
            row = a.getRow(r);
            for (Integer c : row.values.keySet()) {
                if (c <= r) continue;
                b.incrementValue(r, -row.get(c).doubleValue() * b.get(c));
            }
            b.set(r, b.get(r) / row.get(r));
        }
        return b;
    }

    public static DoubleVector multiply(DoubleMatrix matrix, DoubleVector vector) {
        DoubleVector result = new DoubleVector();
        for (int rowIndex = 0; rowIndex < matrix.size(); ++rowIndex) {
            DoubleVector row = matrix.getRow(rowIndex);
            for (Integer index : row.getIndices()) {
                result.incrementValue(rowIndex, row.get(index) * vector.get(index));
            }
        }
        return result;
    }

    public static double normalize(DoubleVector vector) {
        double len = 0.0;
        for (Integer index : vector.getIndices()) {
            Double d = vector.get(index);
            len += d * d;
        }
        len = Math.sqrt(len);
        for (Integer index : vector.getIndices()) {
            vector.set(index, vector.get(index) / len);
        }
        return len;
    }

    public static class DoubleMatrix {
        Map<Integer, DoubleVector> rows = new HashMap<Integer, DoubleVector>();

        public void incrementValue(Integer rowIndex, Integer columnIndex, double increment) {
            DoubleVector row = this.rows.get(rowIndex);
            if (row == null) {
                row = new DoubleVector();
                this.rows.put(rowIndex, row);
            }
            row.incrementValue(columnIndex, increment);
        }

        public void set(Integer rowIndex, Integer columnIndex, double value) {
            DoubleVector row = this.rows.get(rowIndex);
            if (row == null) {
                row = new DoubleVector();
                this.rows.put(rowIndex, row);
            }
            row.set(columnIndex, value);
        }

        public Double get(Integer rowIndex, Integer columnIndex) {
            DoubleVector row = this.rows.get(rowIndex);
            if (row == null) {
                return null;
            }
            return row.get(columnIndex);
        }

        public DoubleVector getRow(Integer rowIndex) {
            return this.rows.get(rowIndex);
        }

        public void setRow(Integer rowIndex, DoubleVector row) {
            this.rows.put(rowIndex, row);
        }

        public String toString() {
            String res = "";
            for (Integer i : this.rows.keySet()) {
                res = res + this.rows.get(i).toString();
            }
            return res;
        }

        public int size() {
            return this.rows.keySet().size();
        }
    }

    public static class DoubleVector {
        Map<Integer, Double> values = new HashMap<Integer, Double>();

        public void incrementValue(Integer index, double increment) {
            Double currentValue = this.values.get(index);
            if (currentValue == null) {
                currentValue = 0.0;
            }
            currentValue = currentValue + increment;
            this.values.put(index, currentValue);
        }

        public void set(Integer index, double value) {
            this.values.put(index, value);
        }

        public Double get(Integer index) {
            return this.values.get(index);
        }

        public Set<Integer> getIndices() {
            return this.values.keySet();
        }

        public String toString() {
            String res = "";
            int maxIndex = 0;
            for (Integer i : this.values.keySet()) {
                if (i <= maxIndex) continue;
                maxIndex = i;
            }
            for (int i = 0; i <= maxIndex; ++i) {
                Double value = this.values.get(i);
                if (value == null) {
                    value = 0.0;
                }
                res = res + " " + value;
            }
            return res + "\n";
        }
    }
}

