/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphalgo.CostEvaluator;
import org.neo4j.graphalgo.WeightedPath;
import org.neo4j.graphalgo.impl.util.WeightedPathImpl;
import org.neo4j.graphdb.Path;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.util.NoneStrictMath;

public class TopFetchingWeightedPathIterator
extends PrefetchingIterator<WeightedPath> {
    private final Iterator<Path> paths;
    private List<WeightedPath> shortestPaths;
    private Iterator<WeightedPath> shortestIterator;
    private final CostEvaluator<Double> costEvaluator;
    private double foundWeight;
    private final double epsilon;

    public TopFetchingWeightedPathIterator(Iterator<Path> paths, CostEvaluator<Double> costEvaluator) {
        this(paths, costEvaluator, NoneStrictMath.EPSILON);
    }

    public TopFetchingWeightedPathIterator(Iterator<Path> paths, CostEvaluator<Double> costEvaluator, double epsilon) {
        this.paths = paths;
        this.costEvaluator = costEvaluator;
        this.epsilon = epsilon;
        this.foundWeight = Double.MAX_VALUE;
    }

    protected WeightedPath fetchNextOrNull() {
        if (this.shortestIterator == null) {
            this.shortestPaths = new ArrayList<WeightedPath>();
            while (this.paths.hasNext()) {
                WeightedPathImpl path = new WeightedPathImpl(this.costEvaluator, this.paths.next());
                if (NoneStrictMath.compare((double)path.weight(), (double)this.foundWeight, (double)this.epsilon) < 0) {
                    this.foundWeight = path.weight();
                    this.shortestPaths.clear();
                }
                if (NoneStrictMath.compare((double)path.weight(), (double)this.foundWeight, (double)this.epsilon) > 0) continue;
                this.shortestPaths.add(path);
            }
            this.shortestIterator = this.shortestPaths.iterator();
        }
        return this.shortestIterator.hasNext() ? this.shortestIterator.next() : null;
    }
}

