/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.impl.centrality.NetworkDiameter;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPathDijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;

public class NetworkDiameterTest
extends Neo4jAlgoTestCase {
    protected SingleSourceShortestPath<Double> getSingleSourceShortestPath() {
        return new SingleSourceShortestPathDijkstra((Object)0.0, null, (relationship, direction) -> 1.0, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
    }

    @Test
    public void testBox() {
        graph.makeEdgeChain("a,b,c,d,a");
        NetworkDiameter diameter = new NetworkDiameter(this.getSingleSourceShortestPath(), (Object)0.0, graph.getAllNodes(), (Comparator)new DoubleComparator());
        Assert.assertTrue(((Double)diameter.getCentrality(null) == 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void testPlusShape() {
        graph.makeEdgeChain("a,b,c");
        graph.makeEdgeChain("d,b,e");
        NetworkDiameter diameter = new NetworkDiameter(this.getSingleSourceShortestPath(), (Object)0.0, graph.getAllNodes(), (Comparator)new DoubleComparator());
        Assert.assertTrue(((Double)diameter.getCentrality(null) == 2.0 ? 1 : 0) != 0);
    }

    @Test
    public void testChain() {
        graph.makeEdgeChain("a,b,c,d,e");
        NetworkDiameter diameter = new NetworkDiameter(this.getSingleSourceShortestPath(), (Object)0.0, graph.getAllNodes(), (Comparator)new DoubleComparator());
        Assert.assertTrue(((Double)diameter.getCentrality(null) == 4.0 ? 1 : 0) != 0);
    }
}

