/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.impl.centrality.BetweennessCentrality;
import org.neo4j.graphalgo.impl.centrality.ClosenessCentrality;
import org.neo4j.graphalgo.impl.centrality.CostDivider;
import org.neo4j.graphalgo.impl.centrality.ParallellCentralityCalculation;
import org.neo4j.graphalgo.impl.centrality.ShortestPathBasedCentrality;
import org.neo4j.graphalgo.impl.centrality.StressCentrality;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPathDijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;

public class ParallellCentralityCalculationTest
extends Neo4jAlgoTestCase {
    protected SingleSourceShortestPath<Double> getSingleSourceShortestPath() {
        return new SingleSourceShortestPathDijkstra((Object)0.0, null, (relationship, direction) -> 1.0, (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
    }

    protected void assertCentrality(ShortestPathBasedCentrality<Double, Double> centrality, String nodeId, Double value) {
        Assert.assertTrue((boolean)((Double)centrality.getCentrality(graph.getNode(nodeId))).equals(value));
    }

    @Test
    public void testPlusShape() {
        graph.makeEdgeChain("a,b,c");
        graph.makeEdgeChain("d,b,e");
        SingleSourceShortestPath<Double> singleSourceShortestPath = this.getSingleSourceShortestPath();
        ParallellCentralityCalculation pcc = new ParallellCentralityCalculation(singleSourceShortestPath, graph.getAllNodes());
        BetweennessCentrality betweennessCentrality = new BetweennessCentrality(singleSourceShortestPath, graph.getAllNodes());
        StressCentrality stressCentrality = new StressCentrality(singleSourceShortestPath, graph.getAllNodes());
        ClosenessCentrality closenessCentrality = new ClosenessCentrality(singleSourceShortestPath, (CostAccumulator)new DoubleAdder(), (Object)0.0, graph.getAllNodes(), (CostDivider)new CostDivider<Double>(){

            public Double divideByCost(Double d, Double c) {
                return d / c;
            }

            public Double divideCost(Double c, Double d) {
                return c / d;
            }
        });
        pcc.addCalculation((ShortestPathBasedCentrality)betweennessCentrality);
        pcc.addCalculation((ShortestPathBasedCentrality)stressCentrality);
        pcc.addCalculation((ShortestPathBasedCentrality)closenessCentrality);
        pcc.calculate();
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)betweennessCentrality, "a", 0.0);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)betweennessCentrality, "b", 6.0);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)betweennessCentrality, "c", 0.0);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)betweennessCentrality, "d", 0.0);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)betweennessCentrality, "e", 0.0);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)stressCentrality, "a", 0.0);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)stressCentrality, "b", 6.0);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)stressCentrality, "c", 0.0);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)stressCentrality, "d", 0.0);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)stressCentrality, "e", 0.0);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)closenessCentrality, "a", 0.14285714285714285);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)closenessCentrality, "b", 0.25);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)closenessCentrality, "c", 0.14285714285714285);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)closenessCentrality, "d", 0.14285714285714285);
        this.assertCentrality((ShortestPathBasedCentrality<Double, Double>)closenessCentrality, "e", 0.14285714285714285);
    }
}

