/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpath;

import common.Neo4jAlgoTestCase;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphalgo.CommonEvaluators;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.impl.shortestpath.Dijkstra;
import org.neo4j.graphalgo.impl.util.DoubleAdder;
import org.neo4j.graphalgo.impl.util.DoubleComparator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class DijkstraIteratorTest
extends Neo4jAlgoTestCase {
    @Test
    public void testRun() {
        new TestDijkstra().runTest();
    }

    protected class TestDijkstra
    extends Dijkstra<Double> {
        public TestDijkstra() {
            super((Object)0.0, null, null, CommonEvaluators.doubleCostEvaluator((String)"cost"), (CostAccumulator)new DoubleAdder(), (Comparator)new DoubleComparator(), Direction.BOTH, new RelationshipType[]{Neo4jAlgoTestCase.MyRelTypes.R1});
        }

        @Test
        public void runTest() {
            graph.makeEdge("start", "a", "cost", 1.0);
            graph.makeEdge("a", "x", "cost", 9.0);
            graph.makeEdge("a", "b", "cost", Float.valueOf(1.0f));
            graph.makeEdge("b", "x", "cost", 7.0);
            graph.makeEdge("b", "c", "cost", 1L);
            graph.makeEdge("c", "x", "cost", 5);
            graph.makeEdge("c", "d", "cost", (byte)1);
            graph.makeEdge("d", "x", "cost", (short)3);
            graph.makeEdge("d", "e", "cost", 1.0);
            graph.makeEdge("e", "x", "cost", 1.0);
            HashMap<Object, Double> seen1 = new HashMap<Node, Double>();
            HashMap<Object, Double> seen2 = new HashMap<Node, Double>();
            HashMap<Object, Double> dists1 = new HashMap<Node, Double>();
            HashMap<Object, Double> dists2 = new HashMap<Node, Double>();
            TestIterator iter1 = new TestIterator(graph.getNode("start"), this.predecessors1, seen1, seen2, dists1, dists2, false);
            Assert.assertTrue((boolean)iter1.next().equals(graph.getNode("start")));
            Assert.assertTrue((boolean)iter1.next().equals(graph.getNode("a")));
            Assert.assertTrue((seen1.get(graph.getNode("x")) == 10.0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iter1.next().equals(graph.getNode("b")));
            Assert.assertTrue((seen1.get(graph.getNode("x")) == 9.0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iter1.next().equals(graph.getNode("c")));
            Assert.assertTrue((seen1.get(graph.getNode("x")) == 8.0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iter1.next().equals(graph.getNode("d")));
            Assert.assertTrue((seen1.get(graph.getNode("x")) == 7.0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iter1.next().equals(graph.getNode("e")));
            Assert.assertTrue((seen1.get(graph.getNode("x")) == 6.0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iter1.next().equals(graph.getNode("x")));
            Assert.assertTrue((seen1.get(graph.getNode("x")) == 6.0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)iter1.hasNext());
            int count = 0;
            seen1 = new HashMap();
            seen2 = new HashMap();
            dists1 = new HashMap();
            dists2 = new HashMap();
            iter1 = new TestIterator(graph.getNode("start"), this.predecessors1, seen1, seen2, dists1, dists2, false);
            this.numberOfNodesTraversed = 0L;
            this.limitMaxNodesToTraverse(3L);
            count = 0;
            while (iter1.hasNext()) {
                iter1.next();
                ++count;
            }
            Assert.assertTrue((count == 3 ? 1 : 0) != 0);
        }

        protected class TestIterator
        extends Dijkstra.DijstraIterator {
            public TestIterator(Node startNode, HashMap<Node, List<Relationship>> predecessors, HashMap<Node, Double> mySeen, HashMap<Node, Double> otherSeen, HashMap<Node, Double> myDistances, HashMap<Node, Double> otherDistances, boolean backwards) {
                super((Dijkstra)TestDijkstra.this, startNode, predecessors, mySeen, otherSeen, myDistances, otherDistances, backwards);
            }
        }
    }
}

