/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;

class PathImplTest {
    private final EmbeddedProxySPI spi = (EmbeddedProxySPI)Mockito.mock(EmbeddedProxySPI.class);

    PathImplTest() {
    }

    @Test
    void singularNodeWorksForwardsAndBackwards() {
        Node node = PathImplTest.createNode(1337L);
        Path path = PathImpl.singular((Node)node);
        Assertions.assertEquals((Object)node, (Object)path.startNode());
        Assertions.assertEquals((Object)node, (Object)path.endNode());
        Iterator forwardIterator = path.nodes().iterator();
        Assertions.assertTrue((boolean)forwardIterator.hasNext());
        Assertions.assertEquals((Object)node, forwardIterator.next());
        Assertions.assertFalse((boolean)forwardIterator.hasNext());
        Iterator reverseIterator = path.reverseNodes().iterator();
        Assertions.assertTrue((boolean)reverseIterator.hasNext());
        Assertions.assertEquals((Object)node, reverseIterator.next());
        Assertions.assertFalse((boolean)reverseIterator.hasNext());
    }

    @Test
    void pathsWithTheSameContentsShouldBeEqual() {
        Node node = PathImplTest.createNode(1337L);
        Relationship relationship = PathImplTest.createRelationship(1337L, 7331L);
        Path firstPath = new PathImpl.Builder(node).push(relationship).build();
        Path secondPath = new PathImpl.Builder(node).push(relationship).build();
        Assertions.assertEquals((Object)firstPath, (Object)secondPath);
        Assertions.assertEquals((Object)secondPath, (Object)firstPath);
    }

    @Test
    void pathsWithDifferentLengthAreNotEqual() {
        Node node = PathImplTest.createNode(1337L);
        Relationship relationship = PathImplTest.createRelationship(1337L, 7331L);
        Path firstPath = new PathImpl.Builder(node).push(relationship).build();
        Path secondPath = new PathImpl.Builder(node).push(relationship).push(PathImplTest.createRelationship(1337L, 7331L)).build();
        MatcherAssert.assertThat((Object)firstPath, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)secondPath)));
        MatcherAssert.assertThat((Object)secondPath, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)firstPath)));
    }

    @Test
    void testPathReverseNodes() {
        Mockito.when((Object)this.spi.newNodeProxy(Mockito.anyLong())).thenAnswer((Answer)new NodeProxyAnswer());
        Path path = new PathImpl.Builder((Node)this.createNodeProxy(1)).push((Relationship)this.createRelationshipProxy(1, 2)).push((Relationship)this.createRelationshipProxy(2, 3)).build(new PathImpl.Builder((Node)this.createNodeProxy(3)));
        Iterable nodes = path.reverseNodes();
        List nodeList = Iterables.asList((Iterable)nodes);
        Assertions.assertEquals((int)3, (int)nodeList.size());
        Assertions.assertEquals((long)3L, (long)((Node)nodeList.get(0)).getId());
        Assertions.assertEquals((long)2L, (long)((Node)nodeList.get(1)).getId());
        Assertions.assertEquals((long)1L, (long)((Node)nodeList.get(2)).getId());
    }

    @Test
    void testPathNodes() {
        Mockito.when((Object)this.spi.newNodeProxy(Mockito.anyLong())).thenAnswer((Answer)new NodeProxyAnswer());
        Path path = new PathImpl.Builder((Node)this.createNodeProxy(1)).push((Relationship)this.createRelationshipProxy(1, 2)).push((Relationship)this.createRelationshipProxy(2, 3)).build(new PathImpl.Builder((Node)this.createNodeProxy(3)));
        Iterable nodes = path.nodes();
        List nodeList = Iterables.asList((Iterable)nodes);
        Assertions.assertEquals((int)3, (int)nodeList.size());
        Assertions.assertEquals((long)1L, (long)((Node)nodeList.get(0)).getId());
        Assertions.assertEquals((long)2L, (long)((Node)nodeList.get(1)).getId());
        Assertions.assertEquals((long)3L, (long)((Node)nodeList.get(2)).getId());
    }

    private RelationshipProxy createRelationshipProxy(int startNodeId, int endNodeId) {
        return new RelationshipProxy(this.spi, 1L, (long)startNodeId, 1, (long)endNodeId);
    }

    private NodeProxy createNodeProxy(int nodeId) {
        return new NodeProxy(this.spi, (long)nodeId);
    }

    private static Node createNode(long nodeId) {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)nodeId);
        return node;
    }

    private static Relationship createRelationship(long startNodeId, long endNodeId) {
        Relationship relationship = (Relationship)Mockito.mock(Relationship.class);
        Node startNode = PathImplTest.createNode(startNodeId);
        Node endNode = PathImplTest.createNode(endNodeId);
        Mockito.when((Object)relationship.getStartNode()).thenReturn((Object)startNode);
        Mockito.when((Object)relationship.getEndNode()).thenReturn((Object)endNode);
        return relationship;
    }

    private class NodeProxyAnswer
    implements Answer<NodeProxy> {
        private NodeProxyAnswer() {
        }

        public NodeProxy answer(InvocationOnMock invocation) {
            return PathImplTest.this.createNodeProxy(((Number)invocation.getArgument(0)).intValue());
        }
    }
}

