/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphalgo.impl.util.PriorityMap;

class TestPriorityMap {
    TestPriorityMap() {
    }

    @Test
    void testIt() {
        PriorityMap map = PriorityMap.withSelfKeyNaturalOrder();
        map.put((Object)0, (Object)5.0);
        map.put((Object)1, (Object)4.0);
        map.put((Object)1, (Object)4.0);
        map.put((Object)1, (Object)3.0);
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), 1, 3.0);
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), 0, 5.0);
        Assertions.assertNull((Object)map.pop());
        int start = 0;
        int a = 1;
        int b = 2;
        int c = 3;
        int d = 4;
        int e = 6;
        int f = 7;
        int y = 8;
        int x = 9;
        map.put((Object)start, (Object)0.0);
        map.put((Object)a, (Object)1.0);
        map.put((Object)x, (Object)10.0);
        map.put((Object)b, (Object)2.0);
        map.put((Object)x, (Object)9.0);
        map.put((Object)c, (Object)3.0);
        map.put((Object)x, (Object)8.0);
        map.put((Object)x, (Object)6.0);
        map.put((Object)d, (Object)4.0);
        map.put((Object)x, (Object)7.0);
        map.put((Object)e, (Object)5.0);
        map.put((Object)x, (Object)6.0);
        map.put((Object)f, (Object)7.0);
        map.put((Object)y, (Object)8.0);
    }

    @Test
    void shouldReplaceIfBetter() {
        PriorityMap map = PriorityMap.withSelfKeyNaturalOrder();
        map.put((Object)1, (Object)2.0);
        boolean putResult = map.put((Object)1, (Object)1.5);
        Assertions.assertTrue((boolean)putResult);
        PriorityMap.Entry top = map.pop();
        Assertions.assertNull((Object)map.peek());
        Assertions.assertEquals((int)1, (int)((Integer)top.getEntity()));
        Assertions.assertEquals((double)1.5, (double)((Double)top.getPriority()), (double)1.0E-5);
    }

    @Test
    void shouldKeepAllPrioritiesIfToldTo() {
        int entity = 5;
        PriorityMap map = PriorityMap.withSelfKeyNaturalOrder((boolean)false, (boolean)false);
        Assertions.assertTrue((boolean)map.put((Object)entity, (Object)3.0));
        Assertions.assertTrue((boolean)map.put((Object)entity, (Object)2.0));
        Assertions.assertTrue((boolean)map.put((Object)entity, (Object)5.0));
        Assertions.assertTrue((boolean)map.put((Object)entity, (Object)4.0));
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), entity, 2.0);
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), entity, 3.0);
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), entity, 4.0);
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), entity, 5.0);
    }

    @Test
    void inCaseSaveAllPrioritiesShouldHandleNewEntryWithWorsePrio() {
        int first = 1;
        int second = 2;
        PriorityMap map = PriorityMap.withSelfKeyNaturalOrder((boolean)false, (boolean)false);
        Assertions.assertTrue((boolean)map.put((Object)first, (Object)1.0));
        Assertions.assertTrue((boolean)map.put((Object)second, (Object)2.0));
        Assertions.assertTrue((boolean)map.put((Object)first, (Object)3.0));
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), first, 1.0);
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), second, 2.0);
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), first, 3.0);
        Assertions.assertNull((Object)map.peek());
    }

    @Test
    void inCaseSaveAllPrioritiesShouldHandleNewEntryWithBetterPrio() {
        int first = 1;
        int second = 2;
        PriorityMap map = PriorityMap.withSelfKeyNaturalOrder((boolean)false, (boolean)false);
        Assertions.assertTrue((boolean)map.put((Object)first, (Object)3.0));
        Assertions.assertTrue((boolean)map.put((Object)second, (Object)2.0));
        Assertions.assertTrue((boolean)map.put((Object)first, (Object)1.0));
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), first, 1.0);
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), second, 2.0);
        TestPriorityMap.assertEntry((PriorityMap.Entry<Integer, Double>)map.pop(), first, 3.0);
        Assertions.assertNull((Object)map.peek());
    }

    private static void assertEntry(PriorityMap.Entry<Integer, Double> entry, Integer entity, Double priority) {
        Assertions.assertNotNull(entry);
        Assertions.assertEquals((Object)entity, (Object)entry.getEntity());
        Assertions.assertEquals((Object)priority, (Object)entry.getPriority());
    }
}

