/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

class PathImplTest {
    private final InternalTransaction transaction = (InternalTransaction)Mockito.mock(InternalTransaction.class, (Answer)Answers.RETURNS_DEEP_STUBS);

    PathImplTest() {
    }

    @Test
    void singularNodeWorksForwardsAndBackwards() {
        Node node = PathImplTest.createNode(1337L);
        Path path = PathImpl.singular((Node)node);
        org.junit.jupiter.api.Assertions.assertEquals((Object)node, (Object)path.startNode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)node, (Object)path.endNode());
        Iterator forwardIterator = path.nodes().iterator();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)forwardIterator.hasNext());
        org.junit.jupiter.api.Assertions.assertEquals((Object)node, forwardIterator.next());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)forwardIterator.hasNext());
        Iterator reverseIterator = path.reverseNodes().iterator();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)reverseIterator.hasNext());
        org.junit.jupiter.api.Assertions.assertEquals((Object)node, reverseIterator.next());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)reverseIterator.hasNext());
    }

    @Test
    void pathsWithTheSameContentsShouldBeEqual() {
        Node node = PathImplTest.createNode(1337L);
        Relationship relationship = PathImplTest.createRelationship(1337L, 7331L);
        Path firstPath = new PathImpl.Builder(node).push(relationship).build();
        Path secondPath = new PathImpl.Builder(node).push(relationship).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstPath, (Object)secondPath);
        org.junit.jupiter.api.Assertions.assertEquals((Object)secondPath, (Object)firstPath);
    }

    @Test
    void pathsWithDifferentLengthAreNotEqual() {
        Node node = PathImplTest.createNode(1337L);
        Relationship relationship = PathImplTest.createRelationship(1337L, 7331L);
        Path firstPath = new PathImpl.Builder(node).push(relationship).build();
        Path secondPath = new PathImpl.Builder(node).push(relationship).push(PathImplTest.createRelationship(1337L, 7331L)).build();
        Assertions.assertThat((Iterable)firstPath).isNotEqualTo((Object)secondPath);
        Assertions.assertThat((Iterable)secondPath).isNotEqualTo((Object)firstPath);
    }

    @Test
    void testPathReverseNodes() {
        Mockito.when((Object)this.transaction.newNodeEntity(Mockito.anyLong())).thenAnswer((Answer)new NodeAnswer());
        PathImpl path = new PathImpl.Builder((Node)this.createNodeEntity(1)).push((Relationship)this.createRelationshipEntity(1, 2)).push((Relationship)this.createRelationshipEntity(2, 3)).build(new PathImpl.Builder((Node)this.createNodeEntity(3)));
        Iterable nodes = path.reverseNodes();
        List nodeList = Iterables.asList((Iterable)nodes);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)nodeList.size());
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)((Node)nodeList.get(0)).getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((Node)nodeList.get(1)).getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)((Node)nodeList.get(2)).getId());
    }

    @Test
    void testPathNodes() {
        Mockito.when((Object)this.transaction.newNodeEntity(Mockito.anyLong())).thenAnswer((Answer)new NodeAnswer());
        PathImpl path = new PathImpl.Builder((Node)this.createNodeEntity(1)).push((Relationship)this.createRelationshipEntity(1, 2)).push((Relationship)this.createRelationshipEntity(2, 3)).build(new PathImpl.Builder((Node)this.createNodeEntity(3)));
        Iterable nodes = path.nodes();
        List nodeList = Iterables.asList((Iterable)nodes);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)nodeList.size());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)((Node)nodeList.get(0)).getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((Node)nodeList.get(1)).getId());
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)((Node)nodeList.get(2)).getId());
    }

    private RelationshipEntity createRelationshipEntity(int startNodeId, int endNodeId) {
        return new RelationshipEntity(this.transaction, 1L, (long)startNodeId, 1, (long)endNodeId);
    }

    private NodeEntity createNodeEntity(int nodeId) {
        return new NodeEntity(this.transaction, (long)nodeId);
    }

    private static Node createNode(long nodeId) {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)nodeId);
        return node;
    }

    private static Relationship createRelationship(long startNodeId, long endNodeId) {
        Relationship relationship = (Relationship)Mockito.mock(Relationship.class);
        Node startNode = PathImplTest.createNode(startNodeId);
        Node endNode = PathImplTest.createNode(endNodeId);
        Mockito.when((Object)relationship.getStartNode()).thenReturn((Object)startNode);
        Mockito.when((Object)relationship.getEndNode()).thenReturn((Object)endNode);
        return relationship;
    }

    private class NodeAnswer
    implements Answer<NodeEntity> {
        private NodeAnswer() {
        }

        public NodeEntity answer(InvocationOnMock invocation) {
            return PathImplTest.this.createNodeEntity(((Number)invocation.getArgument(0)).intValue());
        }
    }
}

