/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.Comparator;
import java.util.function.BiFunction;

public interface PathInterest<P> {
    public Comparator<P> comparator();

    public boolean canBeRuledOut(int var1, P var2, P var3);

    public boolean stillInteresting(int var1);

    public boolean stopAfterLowestCost();

    public static abstract class VisitCountBasedPathInterest<P>
    implements PathInterest<P> {
        abstract int numberOfWantedPaths();

        @Override
        public boolean canBeRuledOut(int numberOfVisits, P pathPriority, P oldPriority) {
            return numberOfVisits > this.numberOfWantedPaths();
        }

        @Override
        public boolean stillInteresting(int numberOfVisits) {
            return numberOfVisits <= this.numberOfWantedPaths();
        }

        @Override
        public boolean stopAfterLowestCost() {
            return false;
        }
    }

    public static abstract class PriorityBasedPathInterest<P>
    implements PathInterest<P> {
        abstract BiFunction<P, P, Boolean> interestFunction();

        @Override
        public boolean canBeRuledOut(int numberOfVisits, P pathPriority, P oldPriority) {
            return this.interestFunction().apply(pathPriority, oldPriority) == false;
        }

        @Override
        public boolean stillInteresting(int numberOfVisits) {
            return true;
        }

        @Override
        public boolean stopAfterLowestCost() {
            return true;
        }
    }
}

