/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.graphcounts;

import java.io.Serializable;
import org.json4s.Formats;
import org.json4s.JsonInput;
import org.json4s.StringInput;
import org.json4s.native.JsonMethods$;
import org.json4s.package$;
import org.neo4j.cypher.graphcounts.Constraint;
import org.neo4j.cypher.graphcounts.GraphCountData;
import org.neo4j.cypher.graphcounts.GraphCountsJson$;
import org.neo4j.cypher.graphcounts.Index;
import org.neo4j.cypher.graphcounts.NodeCount;
import org.neo4j.cypher.graphcounts.RelationshipCount;
import org.neo4j.cypher.internal.util.test_helpers.CypherFunSuite;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00192A\u0001B\u0003\u0001\u001d!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0007q\u0002BB\u0013\u0001A\u0003%qDA\nHe\u0006\u0004\bnQ8v]R\u001c(j]8o)\u0016\u001cHO\u0003\u0002\u0007\u000f\u0005YqM]1qQ\u000e|WO\u001c;t\u0015\tA\u0011\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u0015-\tQA\\3pi)T\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0003\u0001=\u0001\"\u0001E\f\u000e\u0003EQ!AE\n\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005Q)\u0012\u0001B;uS2T!AF\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001G\t\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!B\u0001\bM>\u0014X.\u0019;t+\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\f\u0003\u0019Q7o\u001c85g&\u0011A%\t\u0002\b\r>\u0014X.\u0019;t\u0003!1wN]7biN\u0004\u0003")
public class GraphCountsJsonTest
extends CypherFunSuite {
    private final Formats formats = GraphCountsJson$.MODULE$.allFormats();

    public Formats formats() {
        return this.formats;
    }

    public GraphCountsJsonTest() {
        this.test("Constraint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"label\": \"DeprecatedRelyingParty\",\n        |    \"properties\": [\n        |      \"relyingPartyId\"\n        |    ],\n        |    \"type\": \"Uniqueness constraint\"\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(Constraint.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Constraint((Option)new Some((Object)"DeprecatedRelyingParty"), (Option)None$.MODULE$, (Seq)new .colon.colon((Object)"relyingPartyId", (List)Nil$.MODULE$), ConstraintType.UNIQUE, (Seq)Nil$.MODULE$))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("Relationship Existence Constraint", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"relationshipType\": \"Foo\",\n        |    \"properties\": [\n        |      \"relyingPartyId\"\n        |    ],\n        |    \"type\": \"Existence constraint\"\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(Constraint.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Constraint((Option)None$.MODULE$, (Option)new Some((Object)"Foo"), (Seq)new .colon.colon((Object)"relyingPartyId", (List)Nil$.MODULE$), ConstraintType.EXISTS, (Seq)Nil$.MODULE$))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("index for label", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"estimatedUniqueSize\": 2,\n        |    \"labels\": [\n        |        \"Person\"\n        |    ],\n        |    \"properties\": [\n        |        \"uuid\"\n        |    ],\n        |    \"totalSize\": 2,\n        |    \"updatesSinceEstimation\": 0,\n        |    \"indexType\": \"RANGE\",\n        |    \"indexProvider\": \"range-1.0\"\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(Index.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Index((Option)new Some((Object)new .colon.colon((Object)"Person", (List)Nil$.MODULE$)), (Option)None$.MODULE$, IndexType.RANGE, (Seq)new .colon.colon((Object)"uuid", (List)Nil$.MODULE$), 2L, 2L, 0L, new IndexProviderDescriptor("range", "1.0")))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.test("index for relationship type", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"estimatedUniqueSize\": 2,\n        |    \"relationshipTypes\": [\n        |        \"REL\"\n        |    ],\n        |    \"properties\": [\n        |        \"prop\"\n        |    ],\n        |    \"totalSize\": 2,\n        |    \"updatesSinceEstimation\": 0,\n        |    \"indexType\": \"RANGE\",\n        |    \"indexProvider\": \"range-1.0\"\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(Index.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Index((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)"REL", (List)Nil$.MODULE$)), IndexType.RANGE, (Seq)new .colon.colon((Object)"prop", (List)Nil$.MODULE$), 2L, 2L, 0L, new IndexProviderDescriptor("range", "1.0")))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("lookup index for label", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"estimatedUniqueSize\": 0,\n        |    \"labels\": [],\n        |    \"totalSize\": 0,\n        |    \"updatesSinceEstimation\": 0,\n        |    \"indexType\": \"LOOKUP\",\n        |    \"indexProvider\": \"token-lookup-1.0\"\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(Index.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Index((Option)new Some((Object)Nil$.MODULE$), (Option)None$.MODULE$, IndexType.LOOKUP, (Seq)Nil$.MODULE$, 0L, 0L, 0L, new IndexProviderDescriptor("token-lookup", "1.0")))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("lookup index for relationship type", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"estimatedUniqueSize\": 0,\n        |    \"relationshipTypes\": [],\n        |    \"totalSize\": 0,\n        |    \"updatesSinceEstimation\": 0,\n        |    \"indexType\": \"LOOKUP\",\n        |    \"indexProvider\": \"token-lookup-1.0\"\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(Index.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Index((Option)None$.MODULE$, (Option)new Some((Object)Nil$.MODULE$), IndexType.LOOKUP, (Seq)Nil$.MODULE$, 0L, 0L, 0L, new IndexProviderDescriptor("token-lookup", "1.0")))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("NodeLCount with Label", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"count\": 2,\n        |    \"label\": \"Person\"\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(NodeCount.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new NodeCount(2L, (Option)new Some((Object)"Person")))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.test("NodeCount", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"count\": 2,\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(NodeCount.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new NodeCount(2L, (Option)None$.MODULE$))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("RelationshipCount", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"count\": 5,\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(RelationshipCount.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new RelationshipCount(5L, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("RelationshipCount with type", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"count\": 5,\n        |    \"relationshipType\": \"HAS_SSL_CERTIFICATE\",\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(RelationshipCount.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new RelationshipCount(5L, (Option)new Some((Object)"HAS_SSL_CERTIFICATE"), (Option)None$.MODULE$, (Option)None$.MODULE$))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("RelationshipCount with type and startLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"count\": 5,\n        |    \"relationshipType\": \"HAS_SSL_CERTIFICATE\",\n        |    \"startLabel\": \"RelyingParty\"\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(RelationshipCount.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new RelationshipCount(5L, (Option)new Some((Object)"HAS_SSL_CERTIFICATE"), (Option)new Some((Object)"RelyingParty"), (Option)None$.MODULE$))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("RelationshipCount with type and endLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |    \"count\": 5,\n        |    \"relationshipType\": \"HAS_SSL_CERTIFICATE\",\n        |    \"endLabel\": \"RelyingParty\"\n        |}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(RelationshipCount.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new RelationshipCount(5L, (Option)new Some((Object)"HAS_SSL_CERTIFICATE"), (Option)None$.MODULE$, (Option)new Some((Object)"RelyingParty")))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("GraphCountData", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> this.convertToAnyShouldWrapper(package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse((JsonInput)new StringInput(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\"constraints\": [{\n        |    \"label\": \"SSLCertificate\",\n        |    \"properties\": [\n        |        \"serialNumber\"\n        |    ],\n        |    \"type\": \"Uniqueness constraint\"\n        |}, {\n        |    \"label\": \"SSLCertificate\",\n        |    \"properties\": [\n        |      \"serialNumber\"\n        |    ],\n        |    \"type\": \"Property type constraint\",\n        |    \"propertyTypes\": [\n        |      \"STRING\"\n        |    ]\n        |}],\n        |\"indexes\": [{\n        |    \"estimatedUniqueSize\": 4,\n        |    \"labels\": [\n        |        \"SSLCertificate\"\n        |    ],\n        |    \"properties\": [\n        |        \"serialNumber\"\n        |    ],\n        |    \"totalSize\": 4,\n        |    \"updatesSinceEstimation\": 0,\n        |    \"indexType\": \"RANGE\",\n        |    \"indexProvider\" : \"range-1.0\"\n        |}],\n        |\"nodes\": [{\n        |    \"count\": 1,\n        |    \"label\": \"VettingProvider\"\n        |}],\n        |\"relationships\": [{\n        |    \"count\": 1,\n        |    \"relationshipType\": \"HAS_GEOLOCATION\",\n        |    \"startLabel\": \"Address\"\n        |}]}\n      "))), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(this.formats(), ManifestFactory$.MODULE$.classType(GraphCountData.class)), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new GraphCountData((Seq)new .colon.colon((Object)new Constraint((Option)new Some((Object)"SSLCertificate"), (Option)None$.MODULE$, (Seq)new .colon.colon((Object)"serialNumber", (List)Nil$.MODULE$), ConstraintType.UNIQUE, (Seq)Nil$.MODULE$), (List)new .colon.colon((Object)new Constraint((Option)new Some((Object)"SSLCertificate"), (Option)None$.MODULE$, (Seq)new .colon.colon((Object)"serialNumber", (List)Nil$.MODULE$), ConstraintType.PROPERTY_TYPE, (Seq)new .colon.colon((Object)SchemaValueType.STRING, (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)new Index((Option)new Some((Object)new .colon.colon((Object)"SSLCertificate", (List)Nil$.MODULE$)), (Option)None$.MODULE$, IndexType.RANGE, (Seq)new .colon.colon((Object)"serialNumber", (List)Nil$.MODULE$), 4L, 4L, 0L, new IndexProviderDescriptor("range", "1.0")), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new NodeCount(1L, (Option)new Some((Object)"VettingProvider")), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new RelationshipCount(1L, (Option)new Some((Object)"HAS_GEOLOCATION"), (Option)new Some((Object)"Address"), (Option)None$.MODULE$), (List)Nil$.MODULE$)))), new Position("GraphCountsJsonTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
    }
}

