/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphmatching.CommonValueMatchers;
import org.neo4j.graphmatching.PatternMatch;
import org.neo4j.graphmatching.PatternMatcher;
import org.neo4j.graphmatching.PatternNode;
import org.neo4j.graphmatching.PatternRelationship;
import org.neo4j.graphmatching.ValueMatcher;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class TestSiteIndexExamples {
    private static final long MILLSECONDS_PER_DAY = 86400000L;
    private static GraphDatabaseService graphDb;

    public static Iterable<Node> findNodesWithRelationshipsTo(RelationshipType type, Node ... nodes) {
        if (nodes == null || nodes.length == 0) {
            throw new IllegalArgumentException("No nodes supplied");
        }
        final PatternNode requested = new PatternNode();
        PatternNode anchor = null;
        for (Node node : nodes) {
            PatternNode pattern = new PatternNode();
            pattern.setAssociation((PropertyContainer)node);
            pattern.createRelationshipTo(requested, type);
            if (anchor != null) continue;
            anchor = pattern;
        }
        PatternMatcher matcher = PatternMatcher.getMatcher();
        Iterable matches = matcher.match(anchor, nodes[0]);
        return new IterableWrapper<Node, PatternMatch>(matches){

            protected Node underlyingObjectToObject(PatternMatch match) {
                return match.getNodeFor(requested);
            }
        };
    }

    public Iterable<Node> findFriendsSinceSpecifiedTimeInSpecifiedPlace(Node me, String livesIn, final int knownForYears) {
        PatternNode root = new PatternNode();
        PatternNode place = new PatternNode();
        final PatternNode friend = new PatternNode();
        PatternRelationship friendship = root.createRelationshipTo(friend, (RelationshipType)FriendshipTypes.FRIEND, Direction.BOTH);
        friendship.addPropertyConstraint("since", new ValueMatcher(){
            long now = new Date().getTime();

            public boolean matches(Object value) {
                if (value instanceof Long) {
                    long ageInDays = (this.now - (Long)value) / 86400000L;
                    return ageInDays > (long)(knownForYears * 365);
                }
                return false;
            }
        });
        friend.createRelationshipTo(place, (RelationshipType)FriendshipTypes.LIVES_IN);
        place.addPropertyConstraint("name", CommonValueMatchers.exact((Object)livesIn));
        PatternMatcher matcher = PatternMatcher.getMatcher();
        Iterable matches = matcher.match(root, me);
        return new IterableWrapper<Node, PatternMatch>(matches){

            protected Node underlyingObjectToObject(PatternMatch match) {
                return match.getNodeFor(friend);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyFunctionalityOfFindNodesWithRelationshipsTo() throws Exception {
        DynamicRelationshipType type = DynamicRelationshipType.withName((String)"RELATED");
        Node[] nodes = this.createGraph(new GraphDefinition<Node[]>((RelationshipType)type){
            final /* synthetic */ RelationshipType val$type;
            {
                this.val$type = relationshipType;
            }

            @Override
            public Node[] create(GraphDatabaseService graphdb) {
                int i;
                Node[] nodes = new Node[5];
                for (i = 0; i < nodes.length; ++i) {
                    nodes[i] = graphdb.createNode();
                }
                for (i = 0; i < 3; ++i) {
                    Node node = graphdb.createNode();
                    for (int j = 0; j < nodes.length; ++j) {
                        nodes[j].createRelationshipTo(node, this.val$type);
                    }
                }
                return nodes;
            }
        });
        Transaction tx = graphDb.beginTx();
        try {
            Assert.assertEquals((long)3L, (long)this.count(TestSiteIndexExamples.findNodesWithRelationshipsTo((RelationshipType)type, nodes)));
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Test
    public void verifyFunctionalityOfFindFriendsSinceSpecifiedTimeInSpecifiedPlace() throws Exception {
        Node root = this.createGraph(new GraphDefinition<Node>(){
            Calendar calendar = Calendar.getInstance();

            @Override
            public Node create(GraphDatabaseService graphdb) {
                Node me = graphdb.createNode();
                Node stockholm = graphdb.createNode();
                Node gothenburg = graphdb.createNode();
                stockholm.setProperty("name", (Object)"Stockholm");
                gothenburg.setProperty("name", (Object)"Gothenburg");
                Node andy = this.friend(me, graphdb.createNode(), "Andy", 10, stockholm);
                this.friend(me, graphdb.createNode(), "Bob", 5, stockholm);
                Node cecilia = this.friend(me, graphdb.createNode(), "Cecilia", 2, stockholm);
                andy.createRelationshipTo(cecilia, (RelationshipType)FriendshipTypes.FRIEND).setProperty("since", (Object)this.yearsAgo(10));
                this.friend(me, graphdb.createNode(), "David", 10, gothenburg);
                return me;
            }

            Node friend(Node me, Node friend, String name, int knownForYears, Node place) {
                friend.setProperty("name", (Object)name);
                me.createRelationshipTo(friend, (RelationshipType)FriendshipTypes.FRIEND).setProperty("since", (Object)this.yearsAgo(knownForYears));
                friend.createRelationshipTo(place, (RelationshipType)FriendshipTypes.LIVES_IN);
                return friend;
            }

            long yearsAgo(int years) {
                return new GregorianCalendar(this.calendar.get(1) - years, this.calendar.get(2), this.calendar.get(5)).getTime().getTime();
            }
        });
        HashSet<String> expected = new HashSet<String>(Arrays.asList("Andy", "Bob"));
        Iterable<Node> friends = this.findFriendsSinceSpecifiedTimeInSpecifiedPlace(root, "Stockholm", 3);
        for (Node friend : friends) {
            String name = (String)friend.getProperty("name", null);
            Assert.assertNotNull((Object)name);
            Assert.assertTrue((String)("Unexpected friend: " + name), (boolean)expected.remove(name));
        }
        Assert.assertTrue((String)("These friends were not found: " + expected), (boolean)expected.isEmpty());
    }

    private int count(Iterable<?> objects) {
        int count = 0;
        for (Object object : objects) {
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T createGraph(GraphDefinition<T> definition) {
        T result;
        Transaction tx = graphDb.beginTx();
        try {
            result = definition.create(graphDb);
            tx.success();
        }
        finally {
            tx.finish();
        }
        return result;
    }

    @BeforeClass
    public static void startGraphDatabase() {
        graphDb = new EmbeddedGraphDatabase("target/var/db");
    }

    @AfterClass
    public static void shutdownGraphDatabase() {
        graphDb.shutdown();
        graphDb = null;
    }

    private static interface GraphDefinition<RESULT> {
        public RESULT create(GraphDatabaseService var1);
    }

    static enum FriendshipTypes implements RelationshipType
    {
        FRIEND,
        LIVES_IN;

    }
}

