/*
 * Decompiled with CFR 0.152.
 */
package matching;

import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphmatching.CommonValueMatchers;
import org.neo4j.graphmatching.PatternMatch;
import org.neo4j.graphmatching.PatternMatcher;
import org.neo4j.graphmatching.PatternNode;
import org.neo4j.graphmatching.PatternRelationship;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class TestPatternMatching {
    private static GraphDatabaseService graphDb;
    private Transaction tx;

    private Node createInstance(String name) {
        Node node = graphDb.createNode();
        node.setProperty("name", (Object)name);
        return node;
    }

    @BeforeClass
    public static void setUpDb() {
        graphDb = new EmbeddedGraphDatabase("target/var/db");
    }

    @Before
    public void setUpTx() {
        this.tx = graphDb.beginTx();
    }

    @After
    public void tearDownTx() {
        this.tx.finish();
    }

    @AfterClass
    public static void tearDownDb() {
        graphDb.shutdown();
    }

    private Iterable<PatternMatch> doMatch(PatternNode pNode) {
        return PatternMatcher.getMatcher().match(pNode, new HashMap(), new PatternNode[0]);
    }

    private Iterable<PatternMatch> doMatch(PatternNode pNode, Node node) {
        return PatternMatcher.getMatcher().match(pNode, node, new HashMap());
    }

    private Iterable<PatternMatch> doMatch(PatternNode pNode, Node node, PatternNode ... optionalNodes) {
        return PatternMatcher.getMatcher().match(pNode, node, new HashMap(), optionalNodes);
    }

    @Test
    public void testAllRelTypes() {
        MyRelTypes R1 = MyRelTypes.R1;
        MyRelTypes R2 = MyRelTypes.R2;
        Node a1 = this.createInstance("a1");
        Node b1 = this.createInstance("b1");
        HashSet<Relationship> relSet = new HashSet<Relationship>();
        relSet.add(a1.createRelationshipTo(b1, (RelationshipType)R1));
        relSet.add(a1.createRelationshipTo(b1, (RelationshipType)R2));
        PatternNode pA = new PatternNode();
        PatternNode pB = new PatternNode();
        PatternRelationship pRel = pA.createRelationshipTo(pB);
        int count = 0;
        for (PatternMatch match : this.doMatch(pA, a1)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a1);
            Assert.assertEquals((Object)match.getNodeFor(pB), (Object)b1);
            Assert.assertTrue((boolean)relSet.remove(match.getRelationshipFor(pRel)));
            ++count;
        }
        Assert.assertEquals((long)0L, (long)relSet.size());
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testAllRelTypesWithRelProperty() {
        MyRelTypes R1 = MyRelTypes.R1;
        MyRelTypes R2 = MyRelTypes.R2;
        Node a1 = this.createInstance("a1");
        Node b1 = this.createInstance("b1");
        Relationship rel = a1.createRelationshipTo(b1, (RelationshipType)R1);
        rel = a1.createRelationshipTo(b1, (RelationshipType)R2);
        rel.setProperty("musthave", (Object)true);
        PatternNode pA = new PatternNode();
        PatternNode pB = new PatternNode();
        PatternRelationship pRel = pA.createRelationshipTo(pB);
        pRel.addPropertyConstraint("musthave", CommonValueMatchers.has());
        int count = 0;
        for (PatternMatch match : this.doMatch(pA, a1)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a1);
            Assert.assertEquals((Object)match.getNodeFor(pB), (Object)b1);
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testTeethStructure() {
        MyRelTypes R1 = MyRelTypes.R1;
        MyRelTypes R2 = MyRelTypes.R2;
        Node aT = this.createInstance("aType");
        Node a1 = this.createInstance("a1");
        Node bT = this.createInstance("bType");
        Node b1 = this.createInstance("b1");
        Node cT = this.createInstance("cType");
        Node c1 = this.createInstance("c1");
        Node c2 = this.createInstance("c2");
        Node dT = this.createInstance("dType");
        Node d1 = this.createInstance("d1");
        Node d2 = this.createInstance("d2");
        Node eT = this.createInstance("eType");
        Node e1 = this.createInstance("e1");
        aT.createRelationshipTo(a1, (RelationshipType)R1);
        bT.createRelationshipTo(b1, (RelationshipType)R1);
        cT.createRelationshipTo(c1, (RelationshipType)R1);
        cT.createRelationshipTo(c2, (RelationshipType)R1);
        dT.createRelationshipTo(d1, (RelationshipType)R1);
        dT.createRelationshipTo(d2, (RelationshipType)R1);
        eT.createRelationshipTo(e1, (RelationshipType)R1);
        a1.createRelationshipTo(b1, (RelationshipType)R2);
        b1.createRelationshipTo(c1, (RelationshipType)R2);
        b1.createRelationshipTo(c2, (RelationshipType)R2);
        c1.createRelationshipTo(d1, (RelationshipType)R2);
        c2.createRelationshipTo(d2, (RelationshipType)R2);
        d1.createRelationshipTo(e1, (RelationshipType)R2);
        d2.createRelationshipTo(e1, (RelationshipType)R2);
        PatternNode pA = new PatternNode();
        PatternNode pAI = new PatternNode();
        pA.createRelationshipTo(pAI, (RelationshipType)R1);
        PatternNode pB = new PatternNode();
        PatternNode pBI = new PatternNode();
        pB.createRelationshipTo(pBI, (RelationshipType)R1);
        PatternNode pC = new PatternNode();
        PatternNode pCI = new PatternNode();
        pC.createRelationshipTo(pCI, (RelationshipType)R1);
        PatternNode pD = new PatternNode();
        PatternNode pDI = new PatternNode();
        pD.createRelationshipTo(pDI, (RelationshipType)R1);
        PatternNode pE = new PatternNode();
        PatternNode pEI = new PatternNode();
        pE.createRelationshipTo(pEI, (RelationshipType)R1);
        pAI.createRelationshipTo(pBI, (RelationshipType)R2);
        pBI.createRelationshipTo(pCI, (RelationshipType)R2);
        pCI.createRelationshipTo(pDI, (RelationshipType)R2);
        pDI.createRelationshipTo(pEI, (RelationshipType)R2);
        int count = 0;
        for (PatternMatch match : this.doMatch(pA, aT)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)aT);
            Assert.assertEquals((Object)match.getNodeFor(pAI), (Object)a1);
            Assert.assertEquals((Object)match.getNodeFor(pB), (Object)bT);
            Assert.assertEquals((Object)match.getNodeFor(pBI), (Object)b1);
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)cT);
            Node c = match.getNodeFor(pCI);
            if (!c.equals(c1) && !c.equals(c2)) {
                Assert.fail((String)"either c1 or c2");
            }
            Assert.assertEquals((Object)match.getNodeFor(pD), (Object)dT);
            Node d = match.getNodeFor(pDI);
            if (!d.equals(d1) && !d.equals(d2)) {
                Assert.fail((String)"either d1 or d2");
            }
            Assert.assertEquals((Object)match.getNodeFor(pE), (Object)eT);
            Assert.assertEquals((Object)match.getNodeFor(pEI), (Object)e1);
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        count = 0;
        for (PatternMatch match : this.doMatch(pCI, c2)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)aT);
            Assert.assertEquals((Object)match.getNodeFor(pAI), (Object)a1);
            Assert.assertEquals((Object)match.getNodeFor(pB), (Object)bT);
            Assert.assertEquals((Object)match.getNodeFor(pBI), (Object)b1);
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)cT);
            Assert.assertEquals((Object)match.getNodeFor(pCI), (Object)c2);
            Assert.assertEquals((Object)match.getNodeFor(pD), (Object)dT);
            Assert.assertEquals((Object)match.getNodeFor(pDI), (Object)d2);
            Assert.assertEquals((Object)match.getNodeFor(pE), (Object)eT);
            Assert.assertEquals((Object)match.getNodeFor(pEI), (Object)e1);
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testNonCyclicABC() {
        Node a = this.createInstance("A");
        Node b1 = this.createInstance("B1");
        Node b2 = this.createInstance("B2");
        Node b3 = this.createInstance("B3");
        Node c = this.createInstance("C");
        MyRelTypes R = MyRelTypes.R1;
        Relationship rAB1 = a.createRelationshipTo(b1, (RelationshipType)R);
        Relationship rAB2 = a.createRelationshipTo(b2, (RelationshipType)R);
        Relationship rAB3 = a.createRelationshipTo(b3, (RelationshipType)R);
        Relationship rB1C = b1.createRelationshipTo(c, (RelationshipType)R);
        Relationship rB2C = b2.createRelationshipTo(c, (RelationshipType)R);
        Relationship rB3C = b3.createRelationshipTo(c, (RelationshipType)R);
        PatternNode pA = new PatternNode();
        PatternNode pB = new PatternNode();
        PatternNode pC = new PatternNode();
        PatternRelationship pAB = pA.createRelationshipTo(pB, (RelationshipType)R);
        PatternRelationship pBC = pB.createRelationshipTo(pC, (RelationshipType)R);
        int count = 0;
        for (PatternMatch match : this.doMatch(pA, a)) {
            Relationship rB;
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a);
            Node b = match.getNodeFor(pB);
            if (!(b.equals(b1) || b.equals(b2) || b.equals(b3))) {
                Assert.fail((String)"either b1 or b2 or b3");
            }
            if (!(rAB1.equals(rB = match.getRelationshipFor(pAB)) || rAB2.equals(rB) || rAB3.equals(rB))) {
                Assert.fail((String)"either rAB1, rAB2 or rAB3");
            }
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)c);
            Relationship rC = match.getRelationshipFor(pBC);
            if (!(rB1C.equals(rC) || rB2C.equals(rC) || rB3C.equals(rC))) {
                Assert.fail((String)"either rB1C, rB2C or rB3C");
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        for (PatternMatch match : this.doMatch(pB, b2)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a);
            Assert.assertEquals((Object)match.getNodeFor(pB), (Object)b2);
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)c);
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testCyclicABC() {
        Node b;
        Node a = this.createInstance("A");
        Node b1 = this.createInstance("B1");
        Node b2 = this.createInstance("B2");
        Node b3 = this.createInstance("B3");
        Node c = this.createInstance("C");
        MyRelTypes R = MyRelTypes.R1;
        a.createRelationshipTo(b1, (RelationshipType)R);
        a.createRelationshipTo(b2, (RelationshipType)R);
        a.createRelationshipTo(b3, (RelationshipType)R);
        b1.createRelationshipTo(c, (RelationshipType)R);
        b2.createRelationshipTo(c, (RelationshipType)R);
        b3.createRelationshipTo(c, (RelationshipType)R);
        c.createRelationshipTo(a, (RelationshipType)R);
        PatternNode pA = new PatternNode();
        PatternNode pB = new PatternNode();
        PatternNode pC = new PatternNode();
        pA.createRelationshipTo(pB, (RelationshipType)R);
        pB.createRelationshipTo(pC, (RelationshipType)R);
        pC.createRelationshipTo(pA, (RelationshipType)R);
        int count = 0;
        for (PatternMatch match : this.doMatch(pA, a)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a);
            b = match.getNodeFor(pB);
            if (!(b.equals(b1) || b.equals(b2) || b.equals(b3))) {
                Assert.fail((String)"either b1 or b2 or b3");
            }
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)c);
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        for (PatternMatch match : this.doMatch(pB, b2)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a);
            b = match.getNodeFor(pB);
            if (!(b.equals(b1) || b.equals(b2) || b.equals(b3))) {
                Assert.fail((String)"either b1 or b2 or b3");
            }
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)c);
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testPropertyABC() {
        Node a = this.createInstance("A");
        a.setProperty("hasProperty", (Object)true);
        Node b1 = this.createInstance("B1");
        b1.setProperty("equals", (Object)1);
        b1.setProperty("name", (Object)"Thomas Anderson");
        Node b2 = this.createInstance("B2");
        b2.setProperty("equals", (Object)1);
        b2.setProperty("name", (Object)"Thomas Anderson");
        Node b3 = this.createInstance("B3");
        b3.setProperty("equals", (Object)2);
        Node c = this.createInstance("C");
        MyRelTypes R = MyRelTypes.R1;
        a.createRelationshipTo(b1, (RelationshipType)R);
        a.createRelationshipTo(b2, (RelationshipType)R);
        a.createRelationshipTo(b3, (RelationshipType)R);
        b1.createRelationshipTo(c, (RelationshipType)R);
        b2.createRelationshipTo(c, (RelationshipType)R);
        b3.createRelationshipTo(c, (RelationshipType)R);
        PatternNode pA = new PatternNode();
        pA.addPropertyConstraint("hasProperty", CommonValueMatchers.has());
        PatternNode pB = new PatternNode();
        pB.addPropertyConstraint("equals", CommonValueMatchers.exact((Object)1));
        pB.addPropertyConstraint("name", CommonValueMatchers.regex((Pattern)Pattern.compile("^Thomas.*")));
        PatternNode pC = new PatternNode();
        pA.createRelationshipTo(pB, (RelationshipType)R);
        pB.createRelationshipTo(pC, (RelationshipType)R);
        int count = 0;
        for (PatternMatch match : this.doMatch(pA, a)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a);
            Node b = match.getNodeFor(pB);
            if (!b.equals(b1) && !b.equals(b2)) {
                Assert.fail((String)"either b1 or b2");
            }
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)c);
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        count = 0;
        for (PatternMatch match : this.doMatch(pB, b2)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a);
            Assert.assertEquals((Object)match.getNodeFor(pB), (Object)b2);
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)c);
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testOptional() {
        Node a = this.createInstance("A");
        Node b1 = this.createInstance("B1");
        Node b2 = this.createInstance("B2");
        Node c = this.createInstance("C");
        Node d1 = this.createInstance("D1");
        Node d2 = this.createInstance("D2");
        Node e1 = this.createInstance("E1");
        Node e2 = this.createInstance("E2");
        Node f1 = this.createInstance("F1");
        Node f2 = this.createInstance("F2");
        Node f3 = this.createInstance("F3");
        MyRelTypes R1 = MyRelTypes.R1;
        MyRelTypes R2 = MyRelTypes.R2;
        MyRelTypes R3 = MyRelTypes.R3;
        a.createRelationshipTo(b1, (RelationshipType)R1);
        a.createRelationshipTo(b2, (RelationshipType)R1);
        a.createRelationshipTo(c, (RelationshipType)R2);
        a.createRelationshipTo(f1, (RelationshipType)R3);
        a.createRelationshipTo(f2, (RelationshipType)R3);
        a.createRelationshipTo(f3, (RelationshipType)R3);
        c.createRelationshipTo(d1, (RelationshipType)R1);
        c.createRelationshipTo(d2, (RelationshipType)R1);
        d1.createRelationshipTo(e1, (RelationshipType)R2);
        d1.createRelationshipTo(e2, (RelationshipType)R2);
        PatternNode pA = new PatternNode("pA");
        PatternNode pC = new PatternNode("pC");
        pA.createRelationshipTo(pC, (RelationshipType)R2);
        PatternNode oA1 = new PatternNode("pA");
        PatternNode oB1 = new PatternNode("pB");
        oA1.createOptionalRelationshipTo(oB1, (RelationshipType)R1);
        PatternNode oA2 = new PatternNode("pA");
        PatternNode oF2 = new PatternNode("pF");
        oA2.createOptionalRelationshipTo(oF2, (RelationshipType)R3);
        PatternNode oC3 = new PatternNode("pC");
        PatternNode oD3 = new PatternNode("pD");
        PatternNode oE3 = new PatternNode("pE");
        oC3.createOptionalRelationshipTo(oD3, (RelationshipType)R1);
        oD3.createOptionalRelationshipTo(oE3, (RelationshipType)R2);
        int count = 0;
        for (PatternMatch match : this.doMatch(pA, a, oA1, oA2, oC3)) {
            Node fMatch;
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a);
            Node bMatch = match.getNodeFor(oB1);
            if (!bMatch.equals(b1) && !bMatch.equals(b2)) {
                Assert.fail((String)"either b1 or b2");
            }
            if (!((fMatch = match.getNodeFor(oF2)).equals(f1) || fMatch.equals(f2) || fMatch.equals(f3))) {
                Assert.fail((String)"either f1, f2 or f3");
            }
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)c);
            Assert.assertEquals((Object)match.getNodeFor(oD3), (Object)d1);
            Node eMatch = match.getNodeFor(oE3);
            Assert.assertTrue((eMatch.equals(e1) || eMatch.equals(e2) ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)count, (long)12L);
        PatternNode pI = new PatternNode("pI");
        PatternNode pJ = new PatternNode("pJ");
        PatternNode pK = new PatternNode("pK");
        PatternNode pL = new PatternNode("pL");
        pI.createOptionalRelationshipTo(pJ, (RelationshipType)R1);
        pI.createRelationshipTo(pK, (RelationshipType)R2);
        pK.createOptionalRelationshipTo(pL, (RelationshipType)R2);
        count = 0;
        for (PatternMatch match : this.doMatch(pI, a, pI, pK)) {
            Assert.assertEquals((Object)match.getNodeFor(pI), (Object)a);
            Node jMatch = match.getNodeFor(pJ);
            if (!jMatch.equals(b1) && !jMatch.equals(b2)) {
                Assert.fail((String)"either b1 or b2");
            }
            Assert.assertEquals((Object)match.getNodeFor(pK), (Object)c);
            Assert.assertEquals((Object)match.getNodeFor(pL), null);
            ++count;
        }
        Assert.assertEquals((long)count, (long)2L);
    }

    @Test
    public void testOptional2() {
        Node a = this.createInstance("A");
        Node b1 = this.createInstance("B1");
        Node b2 = this.createInstance("B2");
        Node b3 = this.createInstance("B3");
        Node c1 = this.createInstance("C1");
        Node c3 = this.createInstance("C3");
        MyRelTypes R1 = MyRelTypes.R1;
        MyRelTypes R2 = MyRelTypes.R2;
        a.createRelationshipTo(b1, (RelationshipType)R1);
        a.createRelationshipTo(b2, (RelationshipType)R1);
        a.createRelationshipTo(b3, (RelationshipType)R1);
        b1.createRelationshipTo(c1, (RelationshipType)R2);
        b3.createRelationshipTo(c3, (RelationshipType)R2);
        PatternNode pA = new PatternNode("pA");
        PatternNode pB = new PatternNode("pB");
        pA.createRelationshipTo(pB, (RelationshipType)R1);
        PatternNode oB = new PatternNode("pB");
        PatternNode oC = new PatternNode("oC");
        oB.createOptionalRelationshipTo(oC, (RelationshipType)R2);
        int count = 0;
        for (PatternMatch match : this.doMatch(pA, a, oB)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a);
            Node bMatch = match.getNodeFor(pB);
            Node optionalBMatch = match.getNodeFor(oB);
            Node optionalCMatch = match.getNodeFor(oC);
            if (!(bMatch.equals(b1) || bMatch.equals(b2) || bMatch.equals(b3))) {
                Assert.fail((String)"either b1, b2 or b3");
            }
            if (optionalBMatch != null) {
                Assert.assertEquals((Object)bMatch, (Object)optionalBMatch);
                if (optionalBMatch.equals(b1)) {
                    Assert.assertEquals((Object)optionalCMatch, (Object)c1);
                } else if (optionalBMatch.equals(b3)) {
                    Assert.assertEquals((Object)optionalCMatch, (Object)c3);
                } else {
                    Assert.assertEquals((Object)optionalCMatch, null);
                }
            }
            ++count;
        }
        Assert.assertEquals((long)count, (long)3L);
    }

    @Test
    public void testArrayPropertyValues() {
        Node a = this.createInstance("A");
        a.setProperty("hasProperty", (Object)true);
        Node b1 = this.createInstance("B1");
        b1.setProperty("equals", (Object)new Integer[]{19, 1});
        Node b2 = this.createInstance("B2");
        b2.setProperty("equals", (Object)new Integer[]{1, 10, 12});
        Node b3 = this.createInstance("B3");
        b3.setProperty("equals", (Object)2);
        Node c = this.createInstance("C");
        MyRelTypes R = MyRelTypes.R1;
        a.createRelationshipTo(b1, (RelationshipType)R);
        a.createRelationshipTo(b2, (RelationshipType)R);
        a.createRelationshipTo(b3, (RelationshipType)R);
        b1.createRelationshipTo(c, (RelationshipType)R);
        b2.createRelationshipTo(c, (RelationshipType)R);
        b3.createRelationshipTo(c, (RelationshipType)R);
        PatternNode pA = new PatternNode();
        pA.addPropertyConstraint("hasProperty", CommonValueMatchers.has());
        PatternNode pB = new PatternNode();
        pB.addPropertyConstraint("equals", CommonValueMatchers.exactAny((Object)1));
        PatternNode pC = new PatternNode();
        pA.createRelationshipTo(pB, (RelationshipType)R);
        pB.createRelationshipTo(pC, (RelationshipType)R);
        int count = 0;
        for (PatternMatch match : this.doMatch(pA, a)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a);
            Node b = match.getNodeFor(pB);
            if (!b.equals(b1) && !b.equals(b2)) {
                Assert.fail((String)"either b1 or b2");
            }
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)c);
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        count = 0;
        for (PatternMatch match : this.doMatch(pB, b2)) {
            Assert.assertEquals((Object)match.getNodeFor(pA), (Object)a);
            Assert.assertEquals((Object)match.getNodeFor(pB), (Object)b2);
            Assert.assertEquals((Object)match.getNodeFor(pC), (Object)c);
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testDiamond() {
        Node a = this.createInstance("A");
        Node b = this.createInstance("B");
        Node c = this.createInstance("C");
        Node d = this.createInstance("D");
        MyRelTypes R1 = MyRelTypes.R1;
        MyRelTypes R2 = MyRelTypes.R2;
        a.createRelationshipTo(b, (RelationshipType)R1);
        a.createRelationshipTo(d, (RelationshipType)R1);
        b.createRelationshipTo(d, (RelationshipType)R2);
        c.createRelationshipTo(b, (RelationshipType)R1);
        c.createRelationshipTo(d, (RelationshipType)R1);
        PatternNode pA = new PatternNode();
        PatternNode pB = new PatternNode();
        PatternNode pC = new PatternNode();
        PatternNode pD = new PatternNode();
        pA.createRelationshipTo(pB, (RelationshipType)R1, Direction.BOTH);
        pB.createRelationshipTo(pC, (RelationshipType)R2, Direction.BOTH);
        pC.createRelationshipTo(pD, (RelationshipType)R1, Direction.BOTH);
        int count = 0;
        for (PatternMatch match : this.doMatch(pA, a)) {
            ++count;
        }
        Assert.assertEquals((long)4L, (long)count);
    }

    @Test
    public void testDiamondWithAssociation() {
        Node a = this.createInstance("A");
        Node b = this.createInstance("B");
        Node c = this.createInstance("C");
        Node d = this.createInstance("D");
        MyRelTypes R1 = MyRelTypes.R1;
        MyRelTypes R2 = MyRelTypes.R2;
        a.createRelationshipTo(b, (RelationshipType)R1);
        Relationship relAD = a.createRelationshipTo(d, (RelationshipType)R1);
        b.createRelationshipTo(d, (RelationshipType)R2);
        c.createRelationshipTo(b, (RelationshipType)R1);
        c.createRelationshipTo(d, (RelationshipType)R1);
        PatternNode pA = new PatternNode();
        PatternNode pB = new PatternNode();
        PatternNode pC = new PatternNode();
        PatternNode pD = new PatternNode();
        pA.createRelationshipTo(pB, (RelationshipType)R1, Direction.BOTH);
        pB.createRelationshipTo(pC, (RelationshipType)R2, Direction.BOTH);
        PatternRelationship lastRel = pC.createRelationshipTo(pD, (RelationshipType)R1, Direction.BOTH);
        pA.setAssociation((PropertyContainer)a);
        pB.setAssociation((PropertyContainer)b);
        pC.setAssociation((PropertyContainer)d);
        pD.setAssociation((PropertyContainer)a);
        int count = 0;
        for (PatternMatch match : this.doMatch(pA)) {
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        pD.setAssociation(null);
        count = 0;
        for (PatternMatch match : this.doMatch(pA)) {
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        lastRel.setAssociation((PropertyContainer)relAD);
        count = 0;
        for (PatternMatch match : this.doMatch(pA)) {
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    private static enum MyRelTypes implements RelationshipType
    {
        R1,
        R2,
        R3;

    }
}

