/*
 * Decompiled with CFR 0.152.
 */
package matching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphmatching.PatternMatch;
import org.neo4j.graphmatching.PatternMatcher;
import org.neo4j.graphmatching.PatternNode;
import org.neo4j.helpers.collection.IteratorWrapper;

public class TestMatchingOfCircularPattern {
    private static final boolean STATIC_PATTERN = false;
    private static final int EXPECTED_VISIBLE_MESSAGE_COUNT = 3;
    private static Node user;
    private int count;
    private Transaction tx;
    private static GraphDatabaseService graphdb;

    public static void setupGraph() {
        user = graphdb.createNode();
        Node user1 = graphdb.createNode();
        Node user2 = graphdb.createNode();
        Node user3 = graphdb.createNode();
        user.createRelationshipTo(user1, (RelationshipType)DynamicRelationshipType.withName((String)"FOLLOWS"));
        user1.createRelationshipTo(user3, (RelationshipType)DynamicRelationshipType.withName((String)"FOLLOWS"));
        user.createRelationshipTo(user2, (RelationshipType)DynamicRelationshipType.withName((String)"FOLLOWS"));
        TestMatchingOfCircularPattern.createMessage(user, "invisible", user1, user2);
        TestMatchingOfCircularPattern.createMessage(user1, "visible", user, user2, user3);
        TestMatchingOfCircularPattern.createMessage(user1, "visible", user);
        TestMatchingOfCircularPattern.createMessage(user2, "visible", user, user1);
        TestMatchingOfCircularPattern.createMessage(user2, "invisible", user1, user3);
        TestMatchingOfCircularPattern.createMessage(user3, "invisible", user1, user2);
        TestMatchingOfCircularPattern.createMessage(user3, "invisible", user);
    }

    private static void createMessage(Node creator, String text, Node ... visibleBy) {
        Node message = graphdb.createNode();
        message.setProperty("text", (Object)text);
        creator.createRelationshipTo(message, (RelationshipType)DynamicRelationshipType.withName((String)"CREATED"));
        for (Node user : visibleBy) {
            message.createRelationshipTo(user, (RelationshipType)DynamicRelationshipType.withName((String)"IS_VISIBLE_BY"));
        }
    }

    @Test
    public void straightPathsWork() {
        Node start = graphdb.createNode();
        Node u1 = graphdb.createNode();
        Node u2 = graphdb.createNode();
        Node u3 = graphdb.createNode();
        start.createRelationshipTo(u1, (RelationshipType)DynamicRelationshipType.withName((String)"FOLLOWS"));
        start.createRelationshipTo(u2, (RelationshipType)DynamicRelationshipType.withName((String)"FOLLOWS"));
        start.createRelationshipTo(u3, (RelationshipType)DynamicRelationshipType.withName((String)"FOLLOWS"));
        TestMatchingOfCircularPattern.createMessage(u1, "visible", start);
        TestMatchingOfCircularPattern.createMessage(u2, "visible", start);
        TestMatchingOfCircularPattern.createMessage(u3, "visible", start);
        for (Node message : new VisibleMessagesByFollowedUsers(start)) {
            this.verifyMessage(message);
        }
        this.tx.success();
    }

    @Test
    public void messageNodesAreOnlyReturnedOnce() {
        HashMap<Node, Integer> counts = new HashMap<Node, Integer>();
        Iterator<Node> i$ = new VisibleMessagesByFollowedUsers(user).iterator();
        while (i$.hasNext()) {
            Node message;
            Map.Entry seen = (Integer)counts.get(message = i$.next());
            counts.put(message, seen == null ? 1 : (Integer)((Object)seen) + 1);
            ++this.count;
        }
        StringBuilder duplicates = null;
        for (Map.Entry seen : counts.entrySet()) {
            if ((Integer)seen.getValue() <= 1) continue;
            if (duplicates == null) {
                duplicates = new StringBuilder("These nodes occured multiple times (expected once): ");
            } else {
                duplicates.append(", ");
            }
            duplicates.append(seen.getKey());
            duplicates.append(" (");
            duplicates.append(seen.getValue());
            duplicates.append(" times)");
        }
        if (duplicates != null) {
            Assert.fail((String)duplicates.toString());
        }
        this.tx.success();
    }

    @Test
    public void canFindMessageNodesThroughGraphMatching() {
        for (Node message : new VisibleMessagesByFollowedUsers(user)) {
            this.verifyMessage(message);
        }
        this.tx.success();
    }

    @Test
    public void canFindMessageNodesThroughTraversing() {
        for (Node message : TestMatchingOfCircularPattern.traverse(user)) {
            this.verifyMessage(message);
        }
        this.tx.success();
    }

    private void verifyMessage(Node message) {
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"visible", (Object)message.getProperty("text", null));
        ++this.count;
    }

    @Before
    public void resetCount() {
        this.count = 0;
        this.tx = graphdb.beginTx();
    }

    @After
    public void verifyCount() {
        this.tx.finish();
        this.tx = null;
        Assert.assertEquals((long)3L, (long)this.count);
    }

    private static Iterable<Node> traverse(final Node startNode) {
        return startNode.traverse(Traverser.Order.BREADTH_FIRST, TestMatchingOfCircularPattern.stopAtDepth(2), new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition pos) {
                Node node = pos.currentNode();
                return TestMatchingOfCircularPattern.isMessage(node) && TestMatchingOfCircularPattern.isVisibleTo(node, startNode);
            }
        }, (RelationshipType)DynamicRelationshipType.withName((String)"FOLLOWS"), Direction.OUTGOING, (RelationshipType)DynamicRelationshipType.withName((String)"CREATED"), Direction.OUTGOING);
    }

    public static StopEvaluator stopAtDepth(final int depth) {
        return new StopEvaluator(){

            public boolean isStopNode(TraversalPosition currentPos) {
                return currentPos.depth() >= depth;
            }
        };
    }

    static boolean isMessage(Node node) {
        return node.hasProperty("text");
    }

    static boolean isVisibleTo(Node message, Node user) {
        for (Relationship visibility : message.getRelationships((RelationshipType)DynamicRelationshipType.withName((String)"IS_VISIBLE_BY"), Direction.OUTGOING)) {
            if (!visibility.getEndNode().equals(user)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setUpDb() {
        graphdb = new GraphDatabaseFactory().newEmbeddedDatabase("target/var/db");
        Transaction tx = graphdb.beginTx();
        try {
            TestMatchingOfCircularPattern.setupGraph();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @AfterClass
    public static void stopGraphdb() {
        graphdb.shutdown();
        graphdb = null;
    }

    private static class VisibleMessagesByFollowedUsers
    implements Iterable<Node> {
        private final PatternNode start = new PatternNode();
        private final PatternNode message = new PatternNode();
        private final Node startNode;

        public VisibleMessagesByFollowedUsers(Node startNode) {
            this.startNode = startNode;
            this.start.setAssociation((PropertyContainer)startNode);
            PatternNode user = new PatternNode();
            this.start.createRelationshipTo(user, (RelationshipType)DynamicRelationshipType.withName((String)"FOLLOWS"));
            user.createRelationshipTo(this.message, (RelationshipType)DynamicRelationshipType.withName((String)"CREATED"));
            this.message.createRelationshipTo(this.start, (RelationshipType)DynamicRelationshipType.withName((String)"IS_VISIBLE_BY"));
        }

        @Override
        public Iterator<Node> iterator() {
            Iterable matches = PatternMatcher.getMatcher().match(this.start, this.startNode);
            return new IteratorWrapper<Node, PatternMatch>(matches.iterator()){

                protected Node underlyingObjectToObject(PatternMatch match) {
                    return match.getNodeFor(VisibleMessagesByFollowedUsers.this.message);
                }
            };
        }
    }
}

