/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.index;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.index.IndexPopulationProgress;

public class IndexPopulationProgressTest {
    @Test
    public void testNone() throws Exception {
        Assert.assertEquals((float)0.0f, (float)IndexPopulationProgress.NONE.getCompletedPercentage(), (float)0.0f);
    }

    @Test
    public void testDone() throws Exception {
        Assert.assertEquals((float)100.0f, (float)IndexPopulationProgress.DONE.getCompletedPercentage(), (float)0.0f);
    }

    @Test
    public void testNegativeCompleted() throws Exception {
        try {
            new IndexPopulationProgress(-1L, 1L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNegativeTotal() throws Exception {
        try {
            new IndexPopulationProgress(0L, -1L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAllZero() throws Exception {
        IndexPopulationProgress progress = new IndexPopulationProgress(0L, 0L);
        Assert.assertEquals((long)0L, (long)progress.getCompletedCount());
        Assert.assertEquals((long)0L, (long)progress.getTotalCount());
        Assert.assertEquals((float)0.0f, (float)progress.getCompletedPercentage(), (float)0.0f);
    }

    @Test
    public void testCompletedZero() throws Exception {
        IndexPopulationProgress progress = new IndexPopulationProgress(0L, 1L);
        Assert.assertEquals((long)1L, (long)progress.getTotalCount());
        Assert.assertEquals((long)0L, (long)progress.getCompletedCount());
        Assert.assertEquals((float)0.0f, (float)progress.getCompletedPercentage(), (float)0.0f);
    }

    @Test
    public void testCompletedGreaterThanTotal() throws Exception {
        try {
            new IndexPopulationProgress(2L, 1L);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetCompletedPercentage() throws Exception {
        IndexPopulationProgress progress = new IndexPopulationProgress(1L, 2L);
        Assert.assertEquals((float)50.0f, (float)progress.getCompletedPercentage(), (float)0.0f);
    }

    @Test
    public void testGetCompleted() throws Exception {
        IndexPopulationProgress progress = new IndexPopulationProgress(1L, 2L);
        Assert.assertEquals((long)1L, (long)progress.getCompletedCount());
    }

    @Test
    public void testGetTotal() throws Exception {
        IndexPopulationProgress progress = new IndexPopulationProgress(1L, 2L);
        Assert.assertEquals((long)2L, (long)progress.getTotalCount());
    }
}

