/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.traversal;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.impl.traversal.StandardBranchCollisionDetector;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.TraversalBranch;

class StandardBranchCollisionDetectorTest {
    StandardBranchCollisionDetectorTest() {
    }

    @Test
    void testFilteredPathEvaluation() {
        PropertyContainer endNode = (PropertyContainer)Mockito.mock(Node.class);
        PropertyContainer alternativeEndNode = (PropertyContainer)Mockito.mock(Node.class);
        Node startNode = (Node)Mockito.mock(Node.class);
        Evaluator evaluator = (Evaluator)Mockito.mock(Evaluator.class);
        TraversalBranch branch = (TraversalBranch)Mockito.mock(TraversalBranch.class);
        TraversalBranch alternativeBranch = (TraversalBranch)Mockito.mock(TraversalBranch.class);
        Mockito.when((Object)branch.iterator()).thenAnswer((Answer)new IteratorAnswer(endNode));
        Mockito.when((Object)alternativeBranch.iterator()).thenAnswer((Answer)new IteratorAnswer(alternativeEndNode));
        Mockito.when((Object)alternativeBranch.startNode()).thenReturn((Object)startNode);
        Mockito.when((Object)evaluator.evaluate((Path)Mockito.any(Path.class))).thenReturn((Object)Evaluation.INCLUDE_AND_CONTINUE);
        StandardBranchCollisionDetector collisionDetector = new StandardBranchCollisionDetector(evaluator, path -> alternativeEndNode.equals(path.endNode()) && startNode.equals(path.startNode()));
        Collection incoming = collisionDetector.evaluate(branch, Direction.INCOMING);
        Collection outgoing = collisionDetector.evaluate(branch, Direction.OUTGOING);
        Collection alternativeIncoming = collisionDetector.evaluate(alternativeBranch, Direction.INCOMING);
        Collection alternativeOutgoing = collisionDetector.evaluate(alternativeBranch, Direction.OUTGOING);
        Assert.assertNull((Object)incoming);
        Assert.assertNull((Object)outgoing);
        Assert.assertNull((Object)alternativeIncoming);
        Assert.assertEquals((long)1L, (long)alternativeOutgoing.size());
    }

    private static class IteratorAnswer
    implements Answer<Object> {
        private final PropertyContainer endNode;

        IteratorAnswer(PropertyContainer endNode) {
            this.endNode = endNode;
        }

        public Object answer(InvocationOnMock invocation) {
            return Arrays.asList(this.endNode).iterator();
        }
    }
}

