/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.schema.IndexPopulationProgress;

class IndexPopulationProgressTest {
    IndexPopulationProgressTest() {
    }

    @Test
    void testNone() {
        Assertions.assertEquals((double)0.0, (double)IndexPopulationProgress.NONE.getCompletedPercentage(), (double)0.01);
    }

    @Test
    void testDone() {
        Assertions.assertEquals((double)100.0, (double)IndexPopulationProgress.DONE.getCompletedPercentage(), (double)0.01);
    }

    @Test
    void testNegativeCompleted() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IndexPopulationProgress(-1L, 1L));
    }

    @Test
    void testNegativeTotal() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IndexPopulationProgress(0L, -1L));
    }

    @Test
    void testCompletedGreaterThanTotal() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IndexPopulationProgress(2L, 1L));
    }

    @Test
    void testGetCompletedPercentage() {
        IndexPopulationProgress progress = new IndexPopulationProgress(1L, 2L);
        Assertions.assertEquals((float)50.0f, (float)progress.getCompletedPercentage(), (float)0.01f);
    }
}

