/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.visualization.SubgraphMapper;
import org.neo4j.visualization.graphviz.GraphvizWriter;
import org.neo4j.visualization.graphviz.StyleParameter;
import org.neo4j.walk.Walker;

public class TestGraphvizSubgraphOutput {
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void testSimpleGraph() throws Exception {
        GraphDatabaseService neo = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = neo.beginTx();){
            final Node emil = neo.createNode();
            emil.setProperty("name", (Object)"Emil Eifr\u00e9m");
            emil.setProperty("country_of_residence", (Object)"USA");
            final Node tobias = neo.createNode();
            tobias.setProperty("name", (Object)"Tobias Ivarsson");
            tobias.setProperty("country_of_residence", (Object)"Sweden");
            final Node johan = neo.createNode();
            johan.setProperty("name", (Object)"Johan Svensson");
            johan.setProperty("country_of_residence", (Object)"Sweden");
            final Relationship emilKNOWStobias = emil.createRelationshipTo(tobias, (RelationshipType)type.KNOWS);
            final Relationship johanKNOWSemil = johan.createRelationshipTo(emil, (RelationshipType)type.KNOWS);
            final Relationship tobiasKNOWSjohan = tobias.createRelationshipTo(johan, (RelationshipType)type.KNOWS);
            final Relationship tobiasWORKS_FORemil = tobias.createRelationshipTo(emil, (RelationshipType)type.WORKS_FOR);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            SubgraphMapper subgraphMapper = new SubgraphMapper(){

                public String getSubgraphFor(Node node) {
                    if (node.hasProperty("country_of_residence")) {
                        return (String)node.getProperty("country_of_residence");
                    }
                    return null;
                }
            };
            GraphvizWriter writer = new GraphvizWriter(new StyleParameter[0]);
            SubgraphMapper.SubgraphMappingWalker walker = new SubgraphMapper.SubgraphMappingWalker(subgraphMapper){

                protected Iterable<Node> nodes() {
                    return Arrays.asList(emil, tobias, johan);
                }

                protected Iterable<Relationship> relationships() {
                    return Arrays.asList(emilKNOWStobias, johanKNOWSemil, tobiasKNOWSjohan, tobiasWORKS_FORemil);
                }
            };
            writer.emit((OutputStream)out, (Walker)walker);
            tx.success();
        }
    }

    static enum type implements RelationshipType
    {
        KNOWS,
        WORKS_FOR;

    }
}

