/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.tooling.CharacterConverter;

public class CharacterConverterTest {
    private final CharacterConverter converter = new CharacterConverter();

    @Test
    public void shouldConvertCharacter() {
        String candidates = "abcdefghijklmnopqrstuvwxyz\u00e5\u00e4\u00f6\"'^`\\";
        for (int i = 0; i < candidates.length(); ++i) {
            char expected = candidates.charAt(i);
            this.assertCorrectConversion(expected, String.valueOf(expected));
        }
    }

    @Test
    public void shouldConvertRawAscii() {
        for (char expected = '\u0000'; expected < '\uffff'; expected = (char)(expected + '\u0001')) {
            this.assertCorrectConversion(expected, "\\" + expected);
        }
    }

    @Test
    public void shouldConvertEscaped_t_AsTab() {
        char expected = '\t';
        this.assertCorrectConversion(expected, "\\t");
    }

    @Test
    public void shouldConvert_t_AsTab() {
        char expected = '\t';
        this.assertCorrectConversion(expected, "\t");
    }

    @Test
    public void shouldConvertSpelledOut_TAB_AsTab() {
        char expected = '\t';
        this.assertCorrectConversion(expected, "TAB");
    }

    @Test
    public void shouldNotAcceptRandomEscapedStrings() {
        try {
            this.converter.apply("\\bogus");
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotAcceptStrings() {
        try {
            this.converter.apply("bogus");
            Assert.fail((String)"Should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertCorrectConversion(char expected, String material) {
        char converted = this.converter.apply(material).charValue();
        Assert.assertEquals((long)expected, (long)converted);
    }
}

