/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Format;
import org.neo4j.io.ByteUnit;
import org.neo4j.tooling.PrintingImportLogicMonitor;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;

public class PrintingImportLogicMonitorTest {
    private final ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
    private final PrintStream out = new PrintStream(this.outBuffer);
    private final ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
    private final PrintStream err = new PrintStream(this.errBuffer);
    private final ImportLogic.Monitor monitor = new PrintingImportLogicMonitor(this.out, this.err);

    @Test
    public void mayExceedNodeIdCapacity() {
        long capacity = 10000000L;
        long estimatedCount = 12000000L;
        this.monitor.mayExceedNodeIdCapacity(capacity, estimatedCount);
        String text = this.errBuffer.toString();
        Assert.assertTrue((boolean)text.contains("WARNING"));
        Assert.assertTrue((boolean)text.contains("exceed"));
        Assert.assertTrue((boolean)text.contains(String.valueOf(capacity)));
        Assert.assertTrue((boolean)text.contains(String.valueOf(estimatedCount)));
    }

    @Test
    public void mayExceedRelationshipIdCapacity() {
        long capacity = 10000000L;
        long estimatedCount = 12000000L;
        this.monitor.mayExceedRelationshipIdCapacity(capacity, estimatedCount);
        String text = this.errBuffer.toString();
        Assert.assertTrue((boolean)text.contains("WARNING"));
        Assert.assertTrue((boolean)text.contains("exceed"));
        Assert.assertTrue((boolean)text.contains(String.valueOf(capacity)));
        Assert.assertTrue((boolean)text.contains(String.valueOf(estimatedCount)));
    }

    @Test
    public void insufficientHeapSize() {
        long optimalHeapSize = ByteUnit.gibiBytes((long)2L);
        long heapSize = ByteUnit.gibiBytes((long)1L);
        this.monitor.insufficientHeapSize(optimalHeapSize, heapSize);
        String text = this.errBuffer.toString();
        Assert.assertTrue((boolean)text.contains("WARNING"));
        Assert.assertTrue((boolean)text.contains("too small"));
        Assert.assertTrue((boolean)text.contains(Format.bytes((long)heapSize)));
        Assert.assertTrue((boolean)text.contains(Format.bytes((long)optimalHeapSize)));
    }

    @Test
    public void abundantHeapSize() {
        long optimalHeapSize = ByteUnit.gibiBytes((long)2L);
        long heapSize = ByteUnit.gibiBytes((long)10L);
        this.monitor.abundantHeapSize(optimalHeapSize, heapSize);
        String text = this.errBuffer.toString();
        Assert.assertTrue((boolean)text.contains("WARNING"));
        Assert.assertTrue((boolean)text.contains("unnecessarily large"));
        Assert.assertTrue((boolean)text.contains(Format.bytes((long)heapSize)));
        Assert.assertTrue((boolean)text.contains(Format.bytes((long)optimalHeapSize)));
    }

    @Test
    public void insufficientAvailableMemory() {
        long estimatedCacheSize = ByteUnit.gibiBytes((long)2L);
        long optimalHeapSize = ByteUnit.gibiBytes((long)2L);
        long availableMemory = ByteUnit.gibiBytes((long)1L);
        this.monitor.insufficientAvailableMemory(estimatedCacheSize, optimalHeapSize, availableMemory);
        String text = this.errBuffer.toString();
        Assert.assertTrue((boolean)text.contains("WARNING"));
        Assert.assertTrue((boolean)text.contains("may not be sufficient"));
        Assert.assertTrue((boolean)text.contains(Format.bytes((long)estimatedCacheSize)));
        Assert.assertTrue((boolean)text.contains(Format.bytes((long)optimalHeapSize)));
        Assert.assertTrue((boolean)text.contains(Format.bytes((long)availableMemory)));
    }
}

