/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.importer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.commandline.Util;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.IllegalMultilineFieldException;
import org.neo4j.importer.Importer;
import org.neo4j.importer.PrintingImportLogicMonitor;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.ImportLogic;
import org.neo4j.internal.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Collectors;
import org.neo4j.internal.batchimport.input.IdType;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.InputEntityDecorators;
import org.neo4j.internal.batchimport.input.InputException;
import org.neo4j.internal.batchimport.input.MissingRelationshipDataException;
import org.neo4j.internal.batchimport.input.csv.CsvInput;
import org.neo4j.internal.batchimport.input.csv.DataFactories;
import org.neo4j.internal.batchimport.input.csv.DataFactory;
import org.neo4j.internal.batchimport.input.csv.Decorator;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionMonitors;
import org.neo4j.internal.batchimport.staging.SpectrumExecutionMonitor;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;

class CsvImporter
implements Importer {
    static final String DEFAULT_REPORT_FILE_NAME = "import.report";
    private final DatabaseLayout databaseLayout;
    private final Config databaseConfig;
    private final Configuration csvConfig;
    private final org.neo4j.internal.batchimport.Configuration importConfig;
    private final Path reportFile;
    private final IdType idType;
    private final Charset inputEncoding;
    private final boolean ignoreExtraColumns;
    private final boolean skipBadRelationships;
    private final boolean skipDuplicateNodes;
    private final boolean skipBadEntriesLogging;
    private final long badTolerance;
    private final boolean normalizeTypes;
    private final boolean verbose;
    private final Map<Set<String>, List<Path[]>> nodeFiles;
    private final Map<String, List<Path[]>> relationshipFiles;
    private final FileSystemAbstraction fileSystem;
    private final PrintStream stdOut;
    private final PrintStream stdErr;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;

    private CsvImporter(Builder b) {
        this.databaseLayout = Objects.requireNonNull(b.databaseLayout);
        this.databaseConfig = Objects.requireNonNull(b.databaseConfig);
        this.csvConfig = Objects.requireNonNull(b.csvConfig);
        this.importConfig = Objects.requireNonNull(b.importConfig);
        this.reportFile = Objects.requireNonNull(b.reportFile);
        this.idType = Objects.requireNonNull(b.idType);
        this.inputEncoding = Objects.requireNonNull(b.inputEncoding);
        this.ignoreExtraColumns = b.ignoreExtraColumns;
        this.skipBadRelationships = b.skipBadRelationships;
        this.skipDuplicateNodes = b.skipDuplicateNodes;
        this.skipBadEntriesLogging = b.skipBadEntriesLogging;
        this.badTolerance = b.badTolerance;
        this.normalizeTypes = b.normalizeTypes;
        this.verbose = b.verbose;
        this.nodeFiles = Objects.requireNonNull(b.nodeFiles);
        this.relationshipFiles = Objects.requireNonNull(b.relationshipFiles);
        this.fileSystem = Objects.requireNonNull(b.fileSystem);
        this.pageCacheTracer = Objects.requireNonNull(b.pageCacheTracer);
        this.memoryTracker = Objects.requireNonNull(b.memoryTracker);
        this.stdOut = Objects.requireNonNull(b.stdOut);
        this.stdErr = Objects.requireNonNull(b.stdErr);
    }

    @Override
    public void doImport() throws IOException {
        try (OutputStream badOutput = this.fileSystem.openAsOutputStream(this.reportFile, false);
             Collector badCollector = this.getBadCollector(this.skipBadEntriesLogging, badOutput);){
            ZoneId dbTimeZone = (ZoneId)this.databaseConfig.get(GraphDatabaseSettings.db_temporal_timezone);
            Supplier<ZoneId> defaultTimeZone = () -> dbTimeZone;
            Iterable<DataFactory> nodeData = this.nodeData();
            Iterable<DataFactory> relationshipsData = this.relationshipData();
            CsvInput input = new CsvInput(nodeData, DataFactories.defaultFormatNodeFileHeader(defaultTimeZone, (boolean)this.normalizeTypes), relationshipsData, DataFactories.defaultFormatRelationshipFileHeader(defaultTimeZone, (boolean)this.normalizeTypes), this.idType, this.csvConfig, (CsvInput.Monitor)new CsvInput.PrintingMonitor(this.stdOut), this.memoryTracker);
            this.doImport((Input)input, badCollector);
        }
    }

    private void doImport(Input input, Collector badCollector) {
        boolean success = false;
        Path internalLogFile = (Path)this.databaseConfig.get(GraphDatabaseSettings.store_internal_log_path);
        try (JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             OutputStream outputStream = FileSystemUtils.createOrOpenAsOutputStream((FileSystemAbstraction)this.fileSystem, (Path)internalLogFile, (boolean)true);
             Log4jLogProvider logProvider = Util.configuredLogProvider((Config)this.databaseConfig, (OutputStream)outputStream);){
            ExecutionMonitor executionMonitor = this.verbose ? new SpectrumExecutionMonitor(2L, TimeUnit.SECONDS, this.stdOut, 100) : ExecutionMonitors.defaultVisible();
            BatchImporter importer = BatchImporterFactory.withHighestPriority().instantiate(this.databaseLayout, this.fileSystem, null, this.pageCacheTracer, this.importConfig, (LogService)new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)logProvider), executionMonitor, AdditionalInitialIds.EMPTY, this.databaseConfig, RecordFormatSelector.selectForConfig((Config)this.databaseConfig, (LogProvider)logProvider), (ImportLogic.Monitor)new PrintingImportLogicMonitor(this.stdOut, this.stdErr), jobScheduler, badCollector, TransactionLogInitializer.getLogFilesInitializer(), this.memoryTracker);
            CsvImporter.printOverview(this.databaseLayout.databaseDirectory(), this.nodeFiles, this.relationshipFiles, this.importConfig, this.stdOut);
            importer.doImport(input);
            success = true;
        }
        catch (Exception e) {
            throw CsvImporter.andPrintError("Import error", e, this.verbose, this.stdErr);
        }
        finally {
            long numberOfBadEntries = badCollector.badEntries();
            if (this.reportFile != null && numberOfBadEntries > 0L) {
                this.stdOut.println("There were bad entries which were skipped and logged into " + this.reportFile.toAbsolutePath());
            }
            if (!success) {
                this.stdErr.println("WARNING Import failed. The store files in " + this.databaseLayout.databaseDirectory().toAbsolutePath() + " are left as they are, although they are likely in an unusable state. Starting a database on these store files will likely fail or observe inconsistent records so start at your own risk or delete the store manually");
            }
        }
    }

    private static RuntimeException andPrintError(String typeOfError, Exception e, boolean stackTrace, PrintStream err) {
        if (DuplicateInputIdException.class.equals(e.getClass())) {
            CsvImporter.printErrorMessage("Duplicate input ids that would otherwise clash can be put into separate id space.", e, stackTrace, err);
        } else if (MissingRelationshipDataException.class.equals(e.getClass())) {
            CsvImporter.printErrorMessage("Relationship missing mandatory field", e, stackTrace, err);
        } else if (ExceptionUtils.indexOfThrowable((Throwable)e, IllegalMultilineFieldException.class) != -1) {
            CsvImporter.printErrorMessage("Detected field which spanned multiple lines for an import where --multiline-fields=false. If you know that your input data include fields containing new-line characters then import with this option set to true.", e, stackTrace, err);
        } else if (ExceptionUtils.indexOfThrowable((Throwable)e, InputException.class) != -1) {
            CsvImporter.printErrorMessage("Error in input data", e, stackTrace, err);
        } else {
            CsvImporter.printErrorMessage(typeOfError + ": " + e.getMessage(), e, true, err);
        }
        err.println();
        Thread.currentThread().setUncaughtExceptionHandler((t, e1) -> {});
        Exceptions.throwIfUnchecked((Throwable)e);
        return new RuntimeException(e);
    }

    private static void printErrorMessage(String string, Exception e, boolean stackTrace, PrintStream err) {
        err.println(string);
        err.println("Caused by:" + e.getMessage());
        if (stackTrace) {
            e.printStackTrace(err);
        }
    }

    private static void printOverview(Path storeDir, Map<Set<String>, List<Path[]>> nodesFiles, Map<String, List<Path[]>> relationshipsFiles, org.neo4j.internal.batchimport.Configuration configuration, PrintStream out) {
        out.println("Neo4j version: " + Version.getNeo4jVersion());
        out.println("Importing the contents of these files into " + storeDir + ":");
        CsvImporter.printInputFiles("Nodes", nodesFiles, out);
        CsvImporter.printInputFiles("Relationships", relationshipsFiles, out);
        out.println();
        out.println("Available resources:");
        CsvImporter.printIndented("Total machine memory: " + ByteUnit.bytesToString((long)OsBeanUtil.getTotalPhysicalMemory()), out);
        CsvImporter.printIndented("Free machine memory: " + ByteUnit.bytesToString((long)OsBeanUtil.getFreePhysicalMemory()), out);
        CsvImporter.printIndented("Max heap memory : " + ByteUnit.bytesToString((long)Runtime.getRuntime().maxMemory()), out);
        CsvImporter.printIndented("Processors: " + configuration.maxNumberOfProcessors(), out);
        CsvImporter.printIndented("Configured max memory: " + ByteUnit.bytesToString((long)configuration.maxMemoryUsage()), out);
        CsvImporter.printIndented("High-IO: " + configuration.highIO(), out);
        out.println();
    }

    private static void printInputFiles(String name, Map<?, List<Path[]>> inputFiles, PrintStream out) {
        if (inputFiles.isEmpty()) {
            return;
        }
        out.println(name + ":");
        inputFiles.forEach((k, files) -> {
            if (!CsvImporter.isEmptyKey(k)) {
                CsvImporter.printIndented(k + ":", out);
            }
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                Path[] arr;
                for (Path file : arr = (Path[])iterator.next()) {
                    CsvImporter.printIndented(file, out);
                }
            }
            out.println();
        });
    }

    private static boolean isEmptyKey(Object k) {
        if (k instanceof String) {
            return ((String)k).isEmpty();
        }
        if (k instanceof Set) {
            return ((Set)k).isEmpty();
        }
        return false;
    }

    private static void printIndented(Object value, PrintStream out) {
        out.println("  " + value);
    }

    private Iterable<DataFactory> relationshipData() {
        ArrayList<DataFactory> result = new ArrayList<DataFactory>();
        this.relationshipFiles.forEach((defaultTypeName, fileSets) -> {
            Decorator decorator = InputEntityDecorators.defaultRelationshipType((String)defaultTypeName);
            for (Path[] files : fileSets) {
                DataFactory data = DataFactories.data((Decorator)decorator, (Charset)this.inputEncoding, (Path[])files);
                result.add(data);
            }
        });
        return result;
    }

    private Iterable<DataFactory> nodeData() {
        ArrayList<DataFactory> result = new ArrayList<DataFactory>();
        this.nodeFiles.forEach((labels, fileSets) -> {
            Decorator decorator = labels.isEmpty() ? InputEntityDecorators.NO_DECORATOR : InputEntityDecorators.additiveLabels((String[])labels.toArray(new String[0]));
            for (Path[] files : fileSets) {
                DataFactory data = DataFactories.data((Decorator)decorator, (Charset)this.inputEncoding, (Path[])files);
                result.add(data);
            }
        });
        return result;
    }

    private Collector getBadCollector(boolean skipBadEntriesLogging, OutputStream badOutput) {
        return skipBadEntriesLogging ? Collectors.silentBadCollector((long)this.badTolerance) : Collectors.badCollector((OutputStream)badOutput, (long)(this.isIgnoringSomething() ? -1L : 0L), (int)Collectors.collect((boolean)this.skipBadRelationships, (boolean)this.skipDuplicateNodes, (boolean)this.ignoreExtraColumns));
    }

    private boolean isIgnoringSomething() {
        return this.skipBadRelationships || this.skipDuplicateNodes || this.ignoreExtraColumns;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private DatabaseLayout databaseLayout;
        private Config databaseConfig;
        private Configuration csvConfig = Configuration.COMMAS;
        private org.neo4j.internal.batchimport.Configuration importConfig = org.neo4j.internal.batchimport.Configuration.DEFAULT;
        private Path reportFile;
        private IdType idType = IdType.STRING;
        private Charset inputEncoding = StandardCharsets.UTF_8;
        private boolean ignoreExtraColumns;
        private boolean skipBadRelationships;
        private boolean skipDuplicateNodes;
        private boolean skipBadEntriesLogging;
        private long badTolerance;
        private boolean normalizeTypes;
        private boolean verbose;
        private final Map<Set<String>, List<Path[]>> nodeFiles = new HashMap<Set<String>, List<Path[]>>();
        private final Map<String, List<Path[]>> relationshipFiles = new HashMap<String, List<Path[]>>();
        private FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        private PageCacheTracer pageCacheTracer = PageCacheTracer.NULL;
        private MemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
        private PrintStream stdOut = System.out;
        private PrintStream stdErr = System.err;

        Builder() {
        }

        Builder withDatabaseLayout(DatabaseLayout databaseLayout) {
            this.databaseLayout = databaseLayout;
            return this;
        }

        Builder withDatabaseConfig(Config databaseConfig) {
            this.databaseConfig = databaseConfig;
            return this;
        }

        Builder withCsvConfig(Configuration csvConfig) {
            this.csvConfig = csvConfig;
            return this;
        }

        Builder withImportConfig(org.neo4j.internal.batchimport.Configuration importConfig) {
            this.importConfig = importConfig;
            return this;
        }

        Builder withReportFile(Path reportFile) {
            this.reportFile = reportFile;
            return this;
        }

        Builder withIdType(IdType idType) {
            this.idType = idType;
            return this;
        }

        Builder withInputEncoding(Charset inputEncoding) {
            this.inputEncoding = inputEncoding;
            return this;
        }

        Builder withIgnoreExtraColumns(boolean ignoreExtraColumns) {
            this.ignoreExtraColumns = ignoreExtraColumns;
            return this;
        }

        Builder withSkipBadRelationships(boolean skipBadRelationships) {
            this.skipBadRelationships = skipBadRelationships;
            return this;
        }

        Builder withSkipDuplicateNodes(boolean skipDuplicateNodes) {
            this.skipDuplicateNodes = skipDuplicateNodes;
            return this;
        }

        Builder withSkipBadEntriesLogging(boolean skipBadEntriesLogging) {
            this.skipBadEntriesLogging = skipBadEntriesLogging;
            return this;
        }

        Builder withBadTolerance(long badTolerance) {
            this.badTolerance = badTolerance;
            return this;
        }

        Builder withNormalizeTypes(boolean normalizeTypes) {
            this.normalizeTypes = normalizeTypes;
            return this;
        }

        Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        Builder addNodeFiles(Set<String> labels, Path[] files) {
            List list = this.nodeFiles.computeIfAbsent(labels, unused -> new ArrayList());
            list.add(files);
            return this;
        }

        Builder addRelationshipFiles(String defaultRelType, Path[] files) {
            List list = this.relationshipFiles.computeIfAbsent(defaultRelType, unused -> new ArrayList());
            list.add(files);
            return this;
        }

        Builder withFileSystem(FileSystemAbstraction fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        Builder withPageCacheTracer(PageCacheTracer pageCacheTracer) {
            this.pageCacheTracer = pageCacheTracer;
            return this;
        }

        Builder withMemoryTracker(MemoryTracker memoryTracker) {
            this.memoryTracker = memoryTracker;
            return this;
        }

        Builder withStdOut(PrintStream stdOut) {
            this.stdOut = stdOut;
            return this;
        }

        Builder withStdErr(PrintStream stdErr) {
            this.stdErr = stdErr;
            return this;
        }

        CsvImporter build() {
            return new CsvImporter(this);
        }
    }
}

