/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.io.ByteUnit;

class ConfigurationTest {
    ConfigurationTest() {
    }

    @Test
    void shouldOverrideBigPageCacheMemorySettingContainingUnit() {
        Config dbConfig = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.gibiBytes((long)2L));
        Configuration.Overridden config = new Configuration.Overridden(dbConfig);
        long memory = config.pageCacheMemory();
        Assertions.assertEquals((long)Configuration.MAX_PAGE_CACHE_MEMORY, (long)memory);
    }

    @Test
    void shouldOverrideSmallPageCacheMemorySettingContainingUnit() {
        long overridden = ByteUnit.mebiBytes((long)10L);
        Config dbConfig = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)overridden);
        Configuration.Overridden config = new Configuration.Overridden(dbConfig);
        long memory = config.pageCacheMemory();
        Assertions.assertEquals((long)overridden, (long)memory);
    }
}

