/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.BooleanSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.HighestId;
import org.neo4j.test.Race;

class HighestIdTest {
    HighestIdTest() {
    }

    @Test
    void shouldKeepHighest() throws Throwable {
        Race race = new Race();
        final HighestId highestId = new HighestId();
        int threads = Runtime.getRuntime().availableProcessors();
        final CountDownLatch latch = new CountDownLatch(threads);
        final AtomicLongArray highestIds = new AtomicLongArray(threads);
        int c = 0;
        while (c < threads) {
            final int cc = c++;
            race.addContestant(new Runnable(){
                boolean run;
                final ThreadLocalRandom random = ThreadLocalRandom.current();

                @Override
                public void run() {
                    if (this.run) {
                        return;
                    }
                    long highest = 0L;
                    for (int i = 0; i < 10; ++i) {
                        long nextLong = this.random.nextLong(100L);
                        highestId.offer(nextLong);
                        highest = Math.max(highest, nextLong);
                    }
                    highestIds.set(cc, highest);
                    latch.countDown();
                    this.run = true;
                }
            });
        }
        race.withEndCondition(new BooleanSupplier[]{() -> latch.getCount() == 0L});
        race.go();
        long highest = 0L;
        for (int i = 0; i < threads; ++i) {
            highest = Math.max(highest, highestIds.get(i));
        }
        Assertions.assertEquals((long)highest, (long)highestId.get());
    }
}

