/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.NumberArrayPageCacheTestSupport;
import org.neo4j.internal.batchimport.cache.PageCachedNumberArrayFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class ByteArrayTest
extends NumberArrayPageCacheTestSupport {
    private static final byte[] DEFAULT = new byte[50];
    private static final int LENGTH = 1000;
    private static NumberArrayPageCacheTestSupport.Fixture fixture;
    private ByteArray array;

    private static Stream<Arguments> argumentsProvider() throws IOException {
        fixture = ByteArrayTest.prepareDirectoryAndPageCache(ByteArrayTest.class);
        PageCache pageCache = ByteArrayTest.fixture.pageCache;
        Path dir = ByteArrayTest.fixture.directory;
        CursorContextFactory contextFactory = ByteArrayTest.fixture.contextFactory;
        NullLog log = NullLog.getInstance();
        NumberArrayFactory autoWithPageCacheFallback = NumberArrayFactories.auto((PageCache)pageCache, (CursorContextFactory)contextFactory, (Path)dir, (boolean)true, (NumberArrayFactory.Monitor)NumberArrayFactories.NO_MONITOR, (InternalLog)log, (String)"neo4j");
        PageCachedNumberArrayFactory pageCacheArrayFactory = new PageCachedNumberArrayFactory(pageCache, contextFactory, dir, (InternalLog)log, "neo4j");
        int chunkSize = 100;
        return Stream.of(Arguments.of((Object[])new Object[]{NumberArrayFactories.HEAP.newByteArray(1000L, DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE)}), Arguments.of((Object[])new Object[]{NumberArrayFactories.HEAP.newDynamicByteArray((long)chunkSize, DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE)}), Arguments.of((Object[])new Object[]{NumberArrayFactories.OFF_HEAP.newByteArray(1000L, DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE)}), Arguments.of((Object[])new Object[]{NumberArrayFactories.OFF_HEAP.newDynamicByteArray((long)chunkSize, DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE)}), Arguments.of((Object[])new Object[]{NumberArrayFactories.AUTO_WITHOUT_PAGECACHE.newByteArray(1000L, DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE)}), Arguments.of((Object[])new Object[]{NumberArrayFactories.AUTO_WITHOUT_PAGECACHE.newDynamicByteArray((long)chunkSize, DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE)}), Arguments.of((Object[])new Object[]{autoWithPageCacheFallback.newByteArray(1000L, DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE)}), Arguments.of((Object[])new Object[]{autoWithPageCacheFallback.newDynamicByteArray((long)chunkSize, DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE)}), Arguments.of((Object[])new Object[]{pageCacheArrayFactory.newByteArray(1000L, DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE)}), Arguments.of((Object[])new Object[]{pageCacheArrayFactory.newDynamicByteArray((long)chunkSize, DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE)}));
    }

    @AfterAll
    public static void closeFixture() throws Exception {
        fixture.close();
    }

    @AfterEach
    public void after() {
        this.array.close();
    }

    @ParameterizedTest
    @MethodSource(value={"argumentsProvider"})
    public void shouldSetAndGetBasicTypes(ByteArray array) {
        this.array = array;
        int index = 0;
        byte[] actualBytes = new byte[DEFAULT.length];
        byte[] expectedBytes = new byte[actualBytes.length];
        ThreadLocalRandom.current().nextBytes(actualBytes);
        int len = 999;
        for (int i = 0; i < len; ++i) {
            try {
                this.setSimpleValues(index);
                this.setArray(index + 1, actualBytes);
                this.verifySimpleValues(index);
                this.verifyArray(index + 1, actualBytes, expectedBytes);
                continue;
            }
            catch (Throwable throwable) {
                throw new AssertionError("Failure at index " + i, throwable);
            }
        }
    }

    private void setSimpleValues(int index) {
        this.array.setByte((long)index, 0, (byte)123);
        this.array.setShort((long)index, 1, (short)1234);
        this.array.setInt((long)index, 5, 12345);
        this.array.setLong((long)index, 9, 9223372036854775707L);
        this.array.set3ByteInt((long)index, 17, 0xAAAAAA);
        this.array.set5ByteLong((long)index, 20, 0xAAAAAAAAAAL);
        this.array.set6ByteLong((long)index, 25, 0xAAAAAAAAAAAAL);
    }

    private void verifySimpleValues(int index) {
        Assertions.assertEquals((byte)123, (byte)this.array.getByte((long)index, 0));
        Assertions.assertEquals((short)1234, (short)this.array.getShort((long)index, 1));
        Assertions.assertEquals((int)12345, (int)this.array.getInt((long)index, 5));
        Assertions.assertEquals((long)9223372036854775707L, (long)this.array.getLong((long)index, 9));
        Assertions.assertEquals((int)0xAAAAAA, (int)this.array.get3ByteInt((long)index, 17));
        Assertions.assertEquals((long)0xAAAAAAAAAAL, (long)this.array.get5ByteLong((long)index, 20));
        Assertions.assertEquals((long)0xAAAAAAAAAAAAL, (long)this.array.get6ByteLong((long)index, 25));
    }

    private void setArray(int index, byte[] bytes) {
        this.array.set((long)index, bytes);
    }

    private void verifyArray(int index, byte[] actualBytes, byte[] scratchBuffer) {
        this.array.get((long)index, scratchBuffer);
        Assertions.assertArrayEquals((byte[])actualBytes, (byte[])scratchBuffer);
    }

    @ParameterizedTest
    @MethodSource(value={"argumentsProvider"})
    public void shouldDetectMinusOneFor3ByteInts(ByteArray array) {
        this.array = array;
        array.set3ByteInt(10L, 2, -1);
        array.set3ByteInt(10L, 5, -1);
        Assertions.assertEquals((long)-1L, (long)array.get3ByteInt(10L, 2));
        Assertions.assertEquals((long)-1L, (long)array.get3ByteInt(10L, 5));
    }

    @ParameterizedTest
    @MethodSource(value={"argumentsProvider"})
    public void shouldDetectMinusOneFor5ByteLongs(ByteArray array) {
        this.array = array;
        array.set5ByteLong(10L, 2, -1L);
        array.set5ByteLong(10L, 7, -1L);
        Assertions.assertEquals((long)-1L, (long)array.get5ByteLong(10L, 2));
        Assertions.assertEquals((long)-1L, (long)array.get5ByteLong(10L, 7));
    }

    @ParameterizedTest
    @MethodSource(value={"argumentsProvider"})
    public void shouldDetectMinusOneFor6ByteLongs(ByteArray array) {
        this.array = array;
        array.set6ByteLong(10L, 2, -1L);
        array.set6ByteLong(10L, 8, -1L);
        Assertions.assertEquals((long)-1L, (long)array.get6ByteLong(10L, 2));
        Assertions.assertEquals((long)-1L, (long)array.get6ByteLong(10L, 8));
    }

    @ParameterizedTest
    @MethodSource(value={"argumentsProvider"})
    public void shouldHandleMultipleCallsToClose(ByteArray array) {
        this.array = array;
        array.close();
        array.close();
    }
}

