/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class DynamicIntArrayTest {
    DynamicIntArrayTest() {
    }

    @Test
    void shouldWorkOnSingleChunk() {
        int defaultValue = 0;
        IntArray array = NumberArrayFactories.AUTO_WITHOUT_PAGECACHE.newDynamicIntArray(10L, defaultValue, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        array.set(4L, 5);
        Assertions.assertEquals((long)5L, (long)array.get(4L));
        Assertions.assertEquals((int)defaultValue, (int)array.get(12L));
        array.set(7L, 1324);
        Assertions.assertEquals((long)1324L, (long)array.get(7L));
    }

    @Test
    void trackHeapMemoryOnArrayAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 300L, 0L, null);
        LongArray longArray = NumberArrayFactories.HEAP.newDynamicLongArray(10L, 1L, (MemoryTracker)memoryTracker);
        Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        longArray.set(0L, 5L);
        Assertions.assertEquals((long)96L, (long)memoryTracker.estimatedHeapMemory());
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackNativeMemoryOnArrayAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 300L, 0L, null);
        try (LongArray longArray = NumberArrayFactories.OFF_HEAP.newDynamicLongArray(10L, 1L, (MemoryTracker)memoryTracker);){
            Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
            Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
            longArray.set(0L, 5L);
            Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
            Assertions.assertEquals((long)80L, (long)memoryTracker.usedNativeMemory());
        }
    }

    @Test
    void shouldChunksAsNeeded() {
        IntArray array = NumberArrayFactories.AUTO_WITHOUT_PAGECACHE.newDynamicIntArray(10L, 0, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long index = 243L;
        int value = 5485748;
        array.set(index, value);
        Assertions.assertEquals((int)value, (int)array.get(index));
    }
}

