/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class DynamicLongArrayTest {
    DynamicLongArrayTest() {
    }

    @Test
    void shouldWorkOnSingleChunk() {
        long defaultValue = 0L;
        LongArray array = NumberArrayFactories.AUTO_WITHOUT_PAGECACHE.newDynamicLongArray(10L, defaultValue, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        array.set(4L, 5L);
        Assertions.assertEquals((long)5L, (long)array.get(4L));
        Assertions.assertEquals((long)defaultValue, (long)array.get(12L));
        array.set(7L, 1324L);
        Assertions.assertEquals((long)1324L, (long)array.get(7L));
    }

    @Test
    void shouldChunksAsNeeded() {
        LongArray array = NumberArrayFactories.AUTO_WITHOUT_PAGECACHE.newDynamicLongArray(10L, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long index = 243L;
        long value = 5485748L;
        array.set(index, value);
        Assertions.assertEquals((long)value, (long)array.get(index));
    }
}

