/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.NumberArrayPageCacheTestSupport;
import org.neo4j.internal.batchimport.cache.PageCachedNumberArrayFactory;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class IntArrayTest
extends NumberArrayPageCacheTestSupport {
    private static NumberArrayPageCacheTestSupport.Fixture fixture;
    private final long seed = System.currentTimeMillis();
    private final Random random = new Random(this.seed);

    IntArrayTest() {
    }

    @BeforeAll
    static void setUp() throws IOException {
        fixture = IntArrayTest.prepareDirectoryAndPageCache(IntArrayTest.class);
    }

    @AfterAll
    static void tearDown() throws Exception {
        fixture.close();
    }

    @TestFactory
    Stream<DynamicTest> shouldHandleSomeRandomSetAndGet() {
        ThrowingConsumer arrayFactoryConsumer = factory -> {
            int length = this.random.nextInt(100000) + 100;
            int defaultValue = this.random.nextInt(2) - 1;
            try (IntArray array = factory.newIntArray((long)length, defaultValue, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                int[] expected = new int[length];
                Arrays.fill(expected, defaultValue);
                int operations = this.random.nextInt(1000) + 10;
                block9: for (int i = 0; i < operations; ++i) {
                    int index = this.random.nextInt(length);
                    int value = this.random.nextInt();
                    switch (this.random.nextInt(3)) {
                        case 0: {
                            array.set((long)index, value);
                            expected[index] = value;
                            continue block9;
                        }
                        case 1: {
                            Assertions.assertEquals((int)expected[index], (int)array.get((long)index), (String)("Seed:" + this.seed));
                            continue block9;
                        }
                        default: {
                            int toIndex = this.random.nextInt(length);
                            array.swap((long)index, (long)toIndex);
                            IntArrayTest.swap(expected, index, toIndex);
                        }
                    }
                }
            }
        };
        return DynamicTest.stream(IntArrayTest.arrayFactories(), IntArrayTest.getNumberArrayFactoryName(), (ThrowingConsumer)arrayFactoryConsumer);
    }

    @TestFactory
    Stream<DynamicTest> shouldHandleMultipleCallsToClose() {
        return DynamicTest.stream(IntArrayTest.arrayFactories(), IntArrayTest.getNumberArrayFactoryName(), factory -> {
            IntArray array = factory.newIntArray(10L, -1, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            array.close();
            array.close();
        });
    }

    private static Function<NumberArrayFactory, String> getNumberArrayFactoryName() {
        return factory -> factory.getClass().getName();
    }

    private static void swap(int[] expected, int fromIndex, int toIndex) {
        int fromValue = expected[fromIndex];
        expected[fromIndex] = expected[toIndex];
        expected[toIndex] = fromValue;
    }

    private static Iterator<NumberArrayFactory> arrayFactories() {
        PageCache pageCache = IntArrayTest.fixture.pageCache;
        Path dir = IntArrayTest.fixture.directory;
        CursorContextFactory contextFactory = IntArrayTest.fixture.contextFactory;
        NullLog log = NullLog.getInstance();
        NumberArrayFactory autoWithPageCacheFallback = NumberArrayFactories.auto((PageCache)pageCache, (CursorContextFactory)contextFactory, (Path)dir, (boolean)true, (NumberArrayFactory.Monitor)NumberArrayFactories.NO_MONITOR, (InternalLog)log, (String)"neo4j");
        PageCachedNumberArrayFactory pageCacheArrayFactory = new PageCachedNumberArrayFactory(pageCache, contextFactory, dir, (InternalLog)log, "neo4j");
        return Iterators.iterator((Object[])new NumberArrayFactory[]{NumberArrayFactories.HEAP, NumberArrayFactories.OFF_HEAP, autoWithPageCacheFallback, pageCacheArrayFactory});
    }
}

