/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.cache.LongBitsManipulator;

class LongBitsManipulatorTest {
    LongBitsManipulatorTest() {
    }

    @Test
    void shouldManageTwoSlots() {
        LongBitsManipulator manipulator = new LongBitsManipulator(new int[]{35, 29});
        long field = 0L;
        field = manipulator.set(field, 0, 10L);
        field = manipulator.set(field, 1, 13L);
        Assertions.assertEquals((long)10L, (long)manipulator.get(field, 0));
        Assertions.assertEquals((long)13L, (long)manipulator.get(field, 1));
    }

    @Test
    void shouldInterpretAllOnesAsMinusOne() {
        LongBitsManipulator manipulator = new LongBitsManipulator(new int[]{35, 29});
        long field = manipulator.template(new boolean[]{true, false});
        Assertions.assertEquals((long)-1L, (long)manipulator.get(field, 0));
    }

    @Test
    void shouldHandleMinusOneValues() {
        LongBitsManipulator manipulator = new LongBitsManipulator(new int[]{1, 5, 10, 16, 32});
        long field = 0L;
        for (int i = 0; i < 5; ++i) {
            int j;
            for (j = 0; j < 5; ++j) {
                long valueAfterClearWouldHaveChangedIt;
                if (j == i) {
                    valueAfterClearWouldHaveChangedIt = manipulator.clear(field, j, true);
                    field = manipulator.set(field, j, -1L);
                    Assertions.assertEquals((long)field, (long)valueAfterClearWouldHaveChangedIt, (String)("Clear(true) and set -1 produced different results for i:" + i + ", j:" + j));
                    continue;
                }
                valueAfterClearWouldHaveChangedIt = manipulator.clear(field, j, false);
                field = manipulator.set(field, j, 0L);
                Assertions.assertEquals((long)field, (long)valueAfterClearWouldHaveChangedIt, (String)("Clear(false) and set 0 produced different results for i:" + i + ", j:" + j));
            }
            for (j = 0; j < 5; ++j) {
                long value = manipulator.get(field, j);
                if (j == i) {
                    Assertions.assertEquals((long)-1L, (long)value);
                    continue;
                }
                Assertions.assertEquals((long)0L, (long)value);
            }
        }
    }
}

