/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class NodeLabelsCacheTest {
    @Inject
    private RandomSupport random;

    NodeLabelsCacheTest() {
    }

    @Test
    void shouldCacheSmallSetOfLabelsPerNode() {
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, 5L, 4, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        NodeLabelsCache.Client client = cache.newClient();
        long nodeId = 0L;
        cache.put(nodeId, new long[]{1L, 2L, 3L});
        long[] readLabels = cache.get(client, nodeId);
        Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 3L}, (long[])NodeLabelsCacheTest.shrunk(readLabels));
    }

    @Test
    void shouldHandleLargeAmountOfLabelsPerNode() {
        int highLabelId = 1000;
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, 10L, highLabelId, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        NodeLabelsCache.Client client = cache.newClient();
        long nodeId = 0L;
        long[] labels = this.randomLabels(200, 1000);
        cache.put(nodeId, labels);
        long[] readLabels = cache.get(client, nodeId);
        Assertions.assertArrayEquals((long[])labels, (long[])readLabels);
    }

    @Test
    void shouldHandleLabelsForManyNodes() {
        long[] labels;
        int i;
        int highLabelId = 1000;
        int numberOfNodes = 100000;
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, (long)numberOfNodes, highLabelId, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        NodeLabelsCache.Client client = cache.newClient();
        long[][] expectedLabels = new long[numberOfNodes][];
        for (i = 0; i < numberOfNodes; ++i) {
            labels = this.randomLabels(this.random.nextInt(30) + 1, highLabelId);
            expectedLabels[i] = labels;
            cache.put((long)i, labels);
        }
        for (i = 0; i < numberOfNodes; ++i) {
            labels = cache.get(client, (long)i);
            Assertions.assertArrayEquals((long[])expectedLabels[i], (long[])NodeLabelsCacheTest.shrunk(labels), (String)("For node " + i));
        }
    }

    @Test
    void shouldEndTargetArrayWithMinusOne() {
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, 20L, 10, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        NodeLabelsCache.Client client = cache.newClient();
        cache.put(10L, new long[]{5L, 6L, 7L, 8L});
        long[] target = cache.get(client, 10L);
        Assertions.assertEquals((long)5L, (long)target[0]);
        Assertions.assertEquals((long)6L, (long)target[1]);
        Assertions.assertEquals((long)7L, (long)target[2]);
        Assertions.assertEquals((long)8L, (long)target[3]);
        Assertions.assertEquals((long)-1L, (long)target[4]);
    }

    @Test
    void shouldReturnEmptyArrayForNodeWithNoLabelsAndNoLabelsWhatsoever() {
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, 10L, 0, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        NodeLabelsCache.Client client = cache.newClient();
        long[] target = cache.get(client, 0L);
        Assertions.assertEquals((long)-1L, (long)target[0]);
    }

    @Test
    void shouldSupportConcurrentGet() throws Throwable {
        int highLabelId = 10;
        int numberOfNodes = 100;
        long[][] expectedLabels = new long[numberOfNodes][];
        NodeLabelsCache cache = new NodeLabelsCache(NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, (long)numberOfNodes, highLabelId, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        for (int i = 0; i < numberOfNodes; ++i) {
            expectedLabels[i] = this.randomLabels(this.random.nextInt(5), highLabelId);
            cache.put((long)i, expectedLabels[i]);
        }
        Race getRace = new Race();
        for (int i = 0; i < 10; ++i) {
            getRace.addContestant((Runnable)new LabelGetter(cache, expectedLabels, numberOfNodes));
        }
        getRace.go();
    }

    private long[] randomLabels(int count, int highId) {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.random.nextInt(highId);
        }
        return result;
    }

    private static long[] shrunk(long[] readLabels) {
        for (int i = 0; i < readLabels.length; ++i) {
            if (readLabels[i] != -1L) continue;
            return Arrays.copyOf(readLabels, i);
        }
        return readLabels;
    }

    private static class LabelGetter
    implements Runnable {
        private final NodeLabelsCache cache;
        private final long[][] expectedLabels;
        private final NodeLabelsCache.Client client;
        private final int numberOfNodes;
        private long[] scratch;

        LabelGetter(NodeLabelsCache cache, long[][] expectedLabels, int numberOfNodes) {
            this.cache = cache;
            this.client = cache.newClient();
            this.expectedLabels = expectedLabels;
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public void run() {
            for (int i = 0; i < 1000; ++i) {
                int nodeId = ThreadLocalRandom.current().nextInt(this.numberOfNodes);
                this.scratch = this.cache.get(this.client, (long)nodeId);
                this.assertCorrectLabels(nodeId, this.scratch);
            }
        }

        private void assertCorrectLabels(int nodeId, long[] gotten) {
            long[] expected = this.expectedLabels[nodeId];
            for (int i = 0; i < expected.length; ++i) {
                Assertions.assertEquals((long)expected[i], (long)gotten[i]);
            }
            if (gotten.length != expected.length) {
                Assertions.assertEquals((long)-1L, (long)gotten[expected.length]);
            }
        }
    }
}

