/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
public class NodeRelationshipCacheTest {
    @Inject
    private RandomSupport random;
    private NodeRelationshipCache cache;

    @AfterEach
    public void after() {
        this.cache.close();
    }

    private static Stream<Long> data() {
        return Stream.of(0L, 0xFFFFFFFEL);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldReportCorrectNumberOfDenseNodes(long base) {
        this.cache = new NodeRelationshipCache(NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, 5, 100, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.cache.setNodeCount(26L);
        NodeRelationshipCacheTest.increment(this.cache, 2L, 10);
        NodeRelationshipCacheTest.increment(this.cache, 5L, 2);
        NodeRelationshipCacheTest.increment(this.cache, 7L, 12);
        NodeRelationshipCacheTest.increment(this.cache, 23L, 4);
        NodeRelationshipCacheTest.increment(this.cache, 24L, 5);
        NodeRelationshipCacheTest.increment(this.cache, 25L, 6);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.cache.isDense(0L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.cache.isDense(2L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.cache.isDense(5L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.cache.isDense(7L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.cache.isDense(23L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.cache.isDense(24L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.cache.isDense(25L));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldGoThroughThePhases(long base) {
        int nodeCount = 10;
        this.cache = new NodeRelationshipCache(NumberArrayFactories.OFF_HEAP, 20, 100, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.cache.setNodeCount((long)nodeCount);
        this.incrementRandomCounts(this.cache, nodeCount, nodeCount * 20);
        long node = NodeRelationshipCacheTest.findNode(this.cache, nodeCount, false);
        NodeRelationshipCacheTest.testNode(this.cache, node, null);
        node = NodeRelationshipCacheTest.findNode(this.cache, nodeCount, true);
        NodeRelationshipCacheTest.testNode(this.cache, node, Direction.OUTGOING);
        NodeRelationshipCacheTest.testNode(this.cache, node, Direction.INCOMING);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldObserveFirstRelationshipAsEmptyInEachDirection(long base) {
        long previous;
        int i;
        this.cache = new NodeRelationshipCache(NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, 1, 100, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        int nodes = 100;
        int typeId = 5;
        Direction[] directions = Direction.values();
        NodeRelationshipCache.GroupVisitor groupVisitor = (NodeRelationshipCache.GroupVisitor)Mockito.mock(NodeRelationshipCache.GroupVisitor.class);
        this.cache.setForwardScan(true, true);
        this.cache.setNodeCount((long)(nodes + 1));
        for (i = 0; i < nodes; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)this.cache.getFirstRel((long)nodes, groupVisitor));
            this.cache.incrementCount((long)i);
            previous = this.cache.getAndPutRelationship((long)i, typeId, directions[i % directions.length], (long)this.random.nextInt(1000000), true);
            org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)previous);
        }
        this.cache.setForwardScan(false, true);
        for (i = 0; i < nodes; ++i) {
            previous = this.cache.getAndPutRelationship((long)i, typeId, directions[i % directions.length], (long)this.random.nextInt(1000000), false);
            org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)previous);
        }
        this.cache.setForwardScan(true, true);
        for (i = 0; i < nodes; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)this.cache.getFirstRel((long)nodes, groupVisitor));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldResetCountAfterGetOnDenseNodes(long base) {
        this.cache = new NodeRelationshipCache(NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, 1, 100, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long nodeId = 0L;
        int typeId = 3;
        this.cache.setNodeCount(1L);
        this.cache.incrementCount(nodeId);
        this.cache.incrementCount(nodeId);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, 10L, true);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, 12L, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.cache.isDense(nodeId));
        long countNoReset = this.cache.getCount(nodeId, typeId, Direction.OUTGOING, false);
        long countDoReset = this.cache.getCount(nodeId, typeId, Direction.OUTGOING, true);
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countNoReset);
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)countDoReset);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.cache.getCount(nodeId, typeId, Direction.OUTGOING, false));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldGetAndPutRelationshipAroundChunkEdge(long base) {
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 10, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long nodeId = 999999L;
        int typeId = 10;
        this.cache.setNodeCount(nodeId + 1L);
        Direction direction = Direction.OUTGOING;
        long relId = 10L;
        this.cache.getAndPutRelationship(nodeId, typeId, direction, relId, false);
        org.junit.jupiter.api.Assertions.assertEquals((long)relId, (long)this.cache.getFirstRel(nodeId, (NodeRelationshipCache.GroupVisitor)Mockito.mock(NodeRelationshipCache.GroupVisitor.class)));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldPutRandomStuff(long base) {
        int typeId = 10;
        int nodes = 10000;
        LongObjectHashMap key = new LongObjectHashMap(nodes);
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 1, 1000, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.cache.setNodeCount((long)nodes);
        for (long nodeId = 0L; nodeId < (long)nodes; ++nodeId) {
            if (!this.random.nextBoolean()) continue;
            this.cache.incrementCount(nodeId);
        }
        for (int i = 0; i < 100000; ++i) {
            int keyIndex;
            long nodeId = this.random.nextLong((long)nodes);
            boolean dense = this.cache.isDense(nodeId);
            Direction direction = (Direction)this.random.among((Object[])Direction.values());
            long relationshipId = this.random.nextLong(1000000L);
            long previousHead = this.cache.getAndPutRelationship(nodeId, typeId, direction, relationshipId, false);
            long[] keyIds = (long[])key.get(nodeId);
            int n = keyIndex = dense ? direction.ordinal() : 0;
            if (keyIds == null) {
                keyIds = NodeRelationshipCacheTest.minusOneLongs(Direction.values().length);
                key.put(nodeId, (Object)keyIds);
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)keyIds[keyIndex], (long)previousHead);
            keyIds[keyIndex] = relationshipId;
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldPut6ByteRelationshipIds(long base) {
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 1, 100, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long sparseNode = 0L;
        long denseNode = 1L;
        long relationshipId = 0xFFFFFFFFFFFEL;
        int typeId = 10;
        this.cache.setNodeCount(2L);
        this.cache.incrementCount(denseNode);
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)this.cache.getAndPutRelationship(sparseNode, typeId, Direction.OUTGOING, relationshipId, false));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)this.cache.getAndPutRelationship(denseNode, typeId, Direction.OUTGOING, relationshipId, false));
        org.junit.jupiter.api.Assertions.assertEquals((long)relationshipId, (long)this.cache.getAndPutRelationship(sparseNode, typeId, Direction.OUTGOING, 1L, false));
        org.junit.jupiter.api.Assertions.assertEquals((long)relationshipId, (long)this.cache.getAndPutRelationship(denseNode, typeId, Direction.OUTGOING, 1L, false));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldFailFastIfTooBigRelationshipId(long base) {
        int typeId = 10;
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 1, 100, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.cache.setNodeCount(1L);
        this.cache.getAndPutRelationship(0L, typeId, Direction.OUTGOING, 0xFFFFFFFFFFFEL, false);
        try {
            this.cache.getAndPutRelationship(0L, typeId, Direction.OUTGOING, 0xFFFFFFFFFFFFL, false);
            org.junit.jupiter.api.Assertions.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("max"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldVisitChangedNodes(long base) {
        int nodes = 100;
        int typeId = 10;
        int chunkSize = 10;
        ArrayList<Long> changedNodes = new ArrayList<Long>();
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 2, chunkSize, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.cache.setNodeCount((long)nodes);
        for (long nodeId = 0L; nodeId < (long)nodes; ++nodeId) {
            if (nodeId >= (long)chunkSize && nodeId < (long)(2 * chunkSize)) continue;
            this.cache.incrementCount(nodeId);
            if (this.random.nextBoolean()) {
                this.cache.incrementCount(nodeId);
            }
            changedNodes.add(nodeId);
        }
        LongHashSet keySparseChanged = new LongHashSet();
        LongHashSet keyDenseChanged = new LongHashSet();
        for (int i = 0; i < nodes / 2; ++i) {
            long nodeId = (Long)this.random.among(changedNodes);
            this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, this.random.nextLong(1000000L), false);
            boolean dense = this.cache.isDense(nodeId);
            (dense ? keyDenseChanged : keySparseChanged).add(nodeId);
        }
        NodeRelationshipCache.NodeChangeVisitor visitor = (arg_0, arg_1) -> NodeRelationshipCacheTest.lambda$shouldVisitChangedNodes$0((MutableLongSet)keySparseChanged, arg_0, arg_1);
        this.cache.visitChangedNodes(visitor, 2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)keySparseChanged.isEmpty(), (String)("There was " + keySparseChanged.size() + " expected sparse changes that weren't reported"));
        visitor = (arg_0, arg_1) -> NodeRelationshipCacheTest.lambda$shouldVisitChangedNodes$1((MutableLongSet)keyDenseChanged, arg_0, arg_1);
        this.cache.visitChangedNodes(visitor, 1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)keyDenseChanged.isEmpty(), (String)("There was " + keyDenseChanged.size() + " expected dense changes that weren reported"));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldFailFastOnTooHighCountOnNode(long base) {
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 10, 100, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long nodeId = 5L;
        long count = 0x7FFFFFFFEL;
        int typeId = 10;
        this.cache.setNodeCount(10L);
        this.cache.setCount(nodeId, count, typeId, Direction.OUTGOING);
        this.cache.incrementCount(nodeId);
        try {
            this.cache.incrementCount(nodeId);
            org.junit.jupiter.api.Assertions.fail((String)"Should have failed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldKeepNextGroupIdForNextRound(long base) {
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 1, 100, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long nodeId = 0L;
        int typeId = 10;
        this.cache.setNodeCount(nodeId + 1L);
        this.cache.incrementCount(nodeId);
        NodeRelationshipCache.GroupVisitor groupVisitor = (NodeRelationshipCache.GroupVisitor)Mockito.mock(NodeRelationshipCache.GroupVisitor.class);
        Mockito.when((Object)groupVisitor.visit(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)1L, (Object[])new Long[]{2L, 3L});
        long relationshipId = 10L;
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, relationshipId, true);
        long firstRelationshipGroupId = this.cache.getFirstRel(nodeId, groupVisitor);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)firstRelationshipGroupId);
        ((NodeRelationshipCache.GroupVisitor)Mockito.verify((Object)groupVisitor)).visit(nodeId, typeId, relationshipId, -1L, -1L);
        this.cache.setForwardScan(false, true);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, relationshipId, false);
        this.cache.setForwardScan(true, true);
        long relationshipId2 = 11L;
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.INCOMING, relationshipId2, true);
        long secondRelationshipGroupId = this.cache.getFirstRel(nodeId, groupVisitor);
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)secondRelationshipGroupId);
        ((NodeRelationshipCache.GroupVisitor)Mockito.verify((Object)groupVisitor)).visit(nodeId, typeId, -1L, relationshipId2, -1L);
        this.cache.setForwardScan(false, true);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, relationshipId2, false);
        this.cache.setForwardScan(true, true);
        relationshipId2 = 10L;
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.BOTH, relationshipId2, true);
        long thirdRelationshipGroupId = this.cache.getFirstRel(nodeId, groupVisitor);
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)thirdRelationshipGroupId);
        ((NodeRelationshipCache.GroupVisitor)Mockito.verify((Object)groupVisitor)).visit(nodeId, typeId, -1L, -1L, relationshipId2);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldHaveDenseNodesWithBigCounts(long base) {
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 1, 100, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long nodeId = 1L;
        int typeId = 10;
        this.cache.setNodeCount(nodeId + 1L);
        this.cache.setCount(nodeId, 2L, typeId, Direction.OUTGOING);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, 1L, true);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.INCOMING, 2L, true);
        long highCountOut = 34359738267L;
        long highCountIn = 34359738317L;
        this.cache.setCount(nodeId, highCountOut, typeId, Direction.OUTGOING);
        this.cache.setCount(nodeId, highCountIn, typeId, Direction.INCOMING);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.OUTGOING, 1L, true);
        this.cache.getAndPutRelationship(nodeId, typeId, Direction.INCOMING, 2L, true);
        org.junit.jupiter.api.Assertions.assertEquals((long)(highCountOut + 1L), (long)this.cache.getCount(nodeId, typeId, Direction.OUTGOING, false));
        org.junit.jupiter.api.Assertions.assertEquals((long)(highCountIn + 1L), (long)this.cache.getCount(nodeId, typeId, Direction.INCOMING, false));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldCacheMultipleDenseNodeRelationshipHeads(long base) {
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 1, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.cache.setNodeCount(10L);
        long nodeId = 3L;
        this.cache.setCount(nodeId, 10L, 0, Direction.OUTGOING);
        HashMap<Pair, Long> firstRelationshipIds = new HashMap<Pair, Long>();
        int typeCount = 3;
        int relationshipId = 0;
        for (int typeId2 = 0; typeId2 < typeCount; ++typeId2) {
            for (Direction direction : Direction.values()) {
                long firstRelationshipId = relationshipId++;
                this.cache.getAndPutRelationship(nodeId, typeId2, direction, firstRelationshipId, true);
                firstRelationshipIds.put(Pair.of((Object)typeId2, (Object)direction), firstRelationshipId);
            }
        }
        AtomicInteger visitCount = new AtomicInteger();
        NodeRelationshipCache.GroupVisitor visitor = (nodeId1, typeId, out, in, loop) -> {
            visitCount.incrementAndGet();
            org.junit.jupiter.api.Assertions.assertEquals((long)((Long)firstRelationshipIds.get(Pair.of((Object)typeId, (Object)Direction.OUTGOING))), (long)out);
            org.junit.jupiter.api.Assertions.assertEquals((long)((Long)firstRelationshipIds.get(Pair.of((Object)typeId, (Object)Direction.INCOMING))), (long)in);
            org.junit.jupiter.api.Assertions.assertEquals((long)((Long)firstRelationshipIds.get(Pair.of((Object)typeId, (Object)Direction.BOTH))), (long)loop);
            return 0L;
        };
        this.cache.getFirstRel(nodeId, visitor);
        org.junit.jupiter.api.Assertions.assertEquals((int)typeCount, (int)visitCount.get());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldHaveSparseNodesWithBigCounts(long base) {
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 1, 100, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long nodeId = 1L;
        int typeId = 10;
        this.cache.setNodeCount(nodeId + 1L);
        long highCount = 34359738267L;
        this.cache.setCount(nodeId, highCount, typeId, Direction.OUTGOING);
        long nextHighCount = this.cache.incrementCount(nodeId);
        org.junit.jupiter.api.Assertions.assertEquals((long)(highCount + 1L), (long)nextHighCount);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldFailFastOnTooHighNodeCount(long base) {
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, 1, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            this.cache.setNodeCount(0x20000000000L);
            org.junit.jupiter.api.Assertions.fail((String)"Should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void shouldAllocateRelationshipGroupWithHighTypeId(long base) {
        int denseNodeThreshold = 1;
        long nodeId = 99L;
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, denseNodeThreshold, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.cache.setNodeCount(nodeId + 1L);
        for (int i = 0; i < denseNodeThreshold * 2; ++i) {
            this.cache.incrementCount(nodeId);
        }
        Assertions.assertThat((boolean)this.cache.isDense(nodeId)).isTrue();
        int typeId1 = 66535;
        int typeId2 = 75535;
        long firstRelId1 = 2134L;
        long firstRelId2 = 34873L;
        Assertions.assertThat((long)this.cache.getAndPutRelationship(nodeId, typeId1, Direction.OUTGOING, firstRelId1, true)).isEqualTo(-1L);
        Assertions.assertThat((long)this.cache.getAndPutRelationship(nodeId, typeId2, Direction.INCOMING, firstRelId2, true)).isEqualTo(-1L);
        MutableIntObjectMap expectedGroups = IntObjectMaps.mutable.empty();
        expectedGroups.put(typeId1, (Object)new long[]{firstRelId1, -1L, -1L});
        expectedGroups.put(typeId2, (Object)new long[]{-1L, firstRelId2, -1L});
        this.cache.getFirstRel(nodeId, (groupNodeId, typeId, out, in, loop) -> {
            Assertions.assertThat((long)groupNodeId).isEqualTo(nodeId);
            long[] group = (long[])expectedGroups.remove(typeId);
            Assertions.assertThat((long[])group).isNotNull();
            Assertions.assertThat((long[])group).isEqualTo((Object)new long[]{out, in, loop});
            return 0L;
        });
        Assertions.assertThat((boolean)expectedGroups.isEmpty()).isTrue();
    }

    @Test
    void shouldMarkAsExplicitlyDense() {
        int denseNodeThreshold = 10;
        long nodeId = 5L;
        this.cache = new NodeRelationshipCache(NumberArrayFactories.HEAP, denseNodeThreshold, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.cache.setNodeCount(10L);
        Assertions.assertThat((boolean)this.cache.isDense(nodeId)).isFalse();
        this.cache.markAsExplicitlyDense(nodeId);
        Assertions.assertThat((boolean)this.cache.isDense(nodeId)).isTrue();
        this.cache.incrementCount(nodeId);
        Assertions.assertThat((boolean)this.cache.isDense(nodeId)).isTrue();
    }

    private static void testNode(NodeRelationshipCache link, long node, Direction direction) {
        int typeId = 0;
        long count = link.getCount(node, typeId, direction, false);
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)link.getAndPutRelationship(node, typeId, direction, 5L, false));
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)link.getAndPutRelationship(node, typeId, direction, 10L, false));
        org.junit.jupiter.api.Assertions.assertEquals((long)count, (long)link.getCount(node, typeId, direction, false));
    }

    private static long findNode(NodeRelationshipCache link, long nodeCount, boolean isDense) {
        for (long i = 0L; i < nodeCount; ++i) {
            if (link.isDense(i) != isDense) continue;
            return i;
        }
        throw new IllegalArgumentException("No dense node found");
    }

    private long incrementRandomCounts(NodeRelationshipCache link, int nodeCount, int i) {
        long highestSeenCount = 0L;
        while (i-- > 0) {
            long node = this.random.nextInt(nodeCount);
            highestSeenCount = Math.max(highestSeenCount, link.incrementCount(node));
        }
        return highestSeenCount;
    }

    private static void increment(NodeRelationshipCache cache, long node, int count) {
        for (int i = 0; i < count; ++i) {
            cache.incrementCount(node);
        }
    }

    private static long[] minusOneLongs(int length) {
        long[] array = new long[length];
        Arrays.fill(array, -1L);
        return array;
    }

    private static /* synthetic */ void lambda$shouldVisitChangedNodes$1(MutableLongSet keyDenseChanged, long nodeId, ByteArray array) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)keyDenseChanged.remove(nodeId), (String)("Unexpected dense change reported for " + nodeId));
    }

    private static /* synthetic */ void lambda$shouldVisitChangedNodes$0(MutableLongSet keySparseChanged, long nodeId, ByteArray array) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)keySparseChanged.remove(nodeId), (String)("Unexpected sparse change reported for " + nodeId));
    }
}

