/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.HeapByteArray;
import org.neo4j.internal.batchimport.cache.HeapIntArray;
import org.neo4j.internal.batchimport.cache.HeapLongArray;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.unsafe.NativeMemoryAllocationRefusedError;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;

class NumberArrayFactoryTest {
    private static final long KILO = 1024L;

    NumberArrayFactoryTest() {
    }

    @Test
    void trackHeapMemoryAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 300L, 0L, null);
        NumberArrayFactories.HEAP.newByteArray(10L, new byte[]{0}, (MemoryTracker)memoryTracker);
        org.junit.jupiter.api.Assertions.assertEquals((long)32L, (long)memoryTracker.estimatedHeapMemory());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 300L, 0L, null);
        NumberArrayFactories.HEAP.newLongArray(10L, 1L, (MemoryTracker)memoryTracker);
        org.junit.jupiter.api.Assertions.assertEquals((long)96L, (long)memoryTracker.estimatedHeapMemory());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 300L, 0L, null);
        NumberArrayFactories.HEAP.newIntArray(10L, 1, (MemoryTracker)memoryTracker);
        org.junit.jupiter.api.Assertions.assertEquals((long)56L, (long)memoryTracker.estimatedHeapMemory());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
    }

    @Test
    void trackNativeMemoryAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, 300L, 0L, null);
        try (ByteArray byteArray = NumberArrayFactories.OFF_HEAP.newByteArray(10L, new byte[]{0}, (MemoryTracker)memoryTracker);){
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
            org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)memoryTracker.usedNativeMemory());
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        try (LongArray longArray = NumberArrayFactories.OFF_HEAP.newLongArray(10L, 1L, (MemoryTracker)memoryTracker);){
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
            org.junit.jupiter.api.Assertions.assertEquals((long)80L, (long)memoryTracker.usedNativeMemory());
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
        try (IntArray intArray = NumberArrayFactories.OFF_HEAP.newIntArray(10L, 1, (MemoryTracker)memoryTracker);){
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
            org.junit.jupiter.api.Assertions.assertEquals((long)40L, (long)memoryTracker.usedNativeMemory());
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)memoryTracker.estimatedHeapMemory());
    }

    @Test
    void shouldPickFirstAvailableCandidateLongArray() {
        NumberArrayFactories.Auto factory = new NumberArrayFactories.Auto(NumberArrayFactories.NO_MONITOR, new NumberArrayFactory[]{NumberArrayFactories.HEAP});
        LongArray array = factory.newLongArray(1024L, -1L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        array.set(1014L, 12345L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(array instanceof HeapLongArray));
        org.junit.jupiter.api.Assertions.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    void shouldPickFirstAvailableCandidateLongArrayWhenSomeDontHaveEnoughMemory() {
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(OutOfMemoryError.class).when((Object)lowMemoryFactory)).newLongArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (MemoryTracker)ArgumentMatchers.any(MemoryTracker.class));
        NumberArrayFactories.Auto factory = new NumberArrayFactories.Auto(NumberArrayFactories.NO_MONITOR, new NumberArrayFactory[]{lowMemoryFactory, NumberArrayFactories.HEAP});
        LongArray array = factory.newLongArray(1024L, -1L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        array.set(1014L, 12345L);
        ((NumberArrayFactory)Mockito.verify((Object)lowMemoryFactory)).newLongArray(1024L, -1L, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(array instanceof HeapLongArray));
        org.junit.jupiter.api.Assertions.assertEquals((long)12345L, (long)array.get(1014L));
    }

    @Test
    void shouldThrowOomOnNotEnoughMemory() {
        FailureMonitor monitor = new FailureMonitor();
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(OutOfMemoryError.class).when((Object)lowMemoryFactory)).newLongArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (MemoryTracker)ArgumentMatchers.any(MemoryTracker.class));
        NumberArrayFactories.Auto factory = new NumberArrayFactories.Auto((NumberArrayFactory.Monitor)monitor, new NumberArrayFactory[]{lowMemoryFactory});
        org.junit.jupiter.api.Assertions.assertThrows(OutOfMemoryError.class, () -> NumberArrayFactoryTest.lambda$shouldThrowOomOnNotEnoughMemory$0((NumberArrayFactory)factory));
    }

    @Test
    void shouldPickFirstAvailableCandidateIntArray() {
        FailureMonitor monitor = new FailureMonitor();
        NumberArrayFactories.Auto factory = new NumberArrayFactories.Auto((NumberArrayFactory.Monitor)monitor, new NumberArrayFactory[]{NumberArrayFactories.HEAP});
        IntArray array = factory.newIntArray(1024L, -1, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        array.set(1014L, 12345);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(array instanceof HeapIntArray));
        org.junit.jupiter.api.Assertions.assertEquals((int)12345, (int)array.get(1014L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)NumberArrayFactories.HEAP, (Object)monitor.successfulFactory);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)monitor.attemptedAllocationFailures.iterator().hasNext());
    }

    @Test
    void shouldPickFirstAvailableCandidateIntArrayWhenSomeThrowOutOfMemoryError() {
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(OutOfMemoryError.class).when((Object)lowMemoryFactory)).newIntArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (MemoryTracker)ArgumentMatchers.any(MemoryTracker.class));
        NumberArrayFactories.Auto factory = new NumberArrayFactories.Auto(NumberArrayFactories.NO_MONITOR, new NumberArrayFactory[]{lowMemoryFactory, NumberArrayFactories.HEAP});
        IntArray array = factory.newIntArray(1024L, -1, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        array.set(1014L, 12345);
        ((NumberArrayFactory)Mockito.verify((Object)lowMemoryFactory)).newIntArray(1024L, -1, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(array instanceof HeapIntArray));
        org.junit.jupiter.api.Assertions.assertEquals((int)12345, (int)array.get(1014L));
    }

    @Test
    void shouldPickFirstAvailableCandidateIntArrayWhenSomeThrowNativeMemoryAllocationRefusedError() {
        NumberArrayFactory lowMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ((NumberArrayFactory)Mockito.doThrow(NativeMemoryAllocationRefusedError.class).when((Object)lowMemoryFactory)).newIntArray(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (MemoryTracker)ArgumentMatchers.any(MemoryTracker.class));
        NumberArrayFactories.Auto factory = new NumberArrayFactories.Auto(NumberArrayFactories.NO_MONITOR, new NumberArrayFactory[]{lowMemoryFactory, NumberArrayFactories.HEAP});
        IntArray array = factory.newIntArray(1024L, -1, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        array.set(1014L, 12345);
        ((NumberArrayFactory)Mockito.verify((Object)lowMemoryFactory, (VerificationMode)Mockito.times((int)1))).newIntArray(1024L, -1, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(array instanceof HeapIntArray));
        org.junit.jupiter.api.Assertions.assertEquals((int)12345, (int)array.get(1014L));
    }

    @Test
    void shouldCatchArithmeticExceptionsAndTryNext() {
        NumberArrayFactory throwingMemoryFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        ArithmeticException failure = new ArithmeticException("This is an artificial failure");
        ((NumberArrayFactory)Mockito.doThrow((Throwable[])new Throwable[]{failure}).when((Object)throwingMemoryFactory)).newByteArray(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyLong(), (MemoryTracker)ArgumentMatchers.any(MemoryTracker.class));
        FailureMonitor monitor = new FailureMonitor();
        NumberArrayFactories.Auto factory = new NumberArrayFactories.Auto((NumberArrayFactory.Monitor)monitor, new NumberArrayFactory[]{throwingMemoryFactory, NumberArrayFactories.HEAP});
        int itemSize = 4;
        ByteArray array = factory.newByteArray(1024L, new byte[itemSize], 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        array.setInt(1014L, 0, 12345);
        ((NumberArrayFactory)Mockito.verify((Object)throwingMemoryFactory)).newByteArray(ArgumentMatchers.eq((long)1024L), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.eq((long)0L), (MemoryTracker)ArgumentMatchers.any(MemoryTracker.class));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(array instanceof HeapByteArray));
        org.junit.jupiter.api.Assertions.assertEquals((int)12345, (int)array.getInt(1014L, 0));
        org.junit.jupiter.api.Assertions.assertEquals((long)(1024L * (long)itemSize), (long)monitor.memory);
        org.junit.jupiter.api.Assertions.assertEquals((Object)NumberArrayFactories.HEAP, (Object)monitor.successfulFactory);
        org.junit.jupiter.api.Assertions.assertEquals((Object)throwingMemoryFactory, (Object)((NumberArrayFactory.AllocationFailure)Iterables.single(monitor.attemptedAllocationFailures)).getFactory());
        Assertions.assertThat((String)((NumberArrayFactory.AllocationFailure)Iterables.single(monitor.attemptedAllocationFailures)).getFailure().getMessage()).contains(new CharSequence[]{failure.getMessage()});
    }

    @Test
    void heapArrayShouldAllowVeryLargeBases() {
        NumberArrayFactories.Auto factory = new NumberArrayFactories.Auto(NumberArrayFactories.NO_MONITOR, new NumberArrayFactory[]{NumberArrayFactories.HEAP});
        NumberArrayFactoryTest.verifyVeryLargeBaseSupport((NumberArrayFactory)factory);
    }

    @Test
    void offHeapArrayShouldAllowVeryLargeBases() {
        NumberArrayFactories.Auto factory = new NumberArrayFactories.Auto(NumberArrayFactories.NO_MONITOR, new NumberArrayFactory[]{NumberArrayFactories.OFF_HEAP});
        NumberArrayFactoryTest.verifyVeryLargeBaseSupport((NumberArrayFactory)factory);
    }

    private static void verifyVeryLargeBaseSupport(NumberArrayFactory factory) {
        long base = 2871185636039L;
        byte[] into = new byte[]{1};
        factory.newByteArray(10L, new byte[1], base, (MemoryTracker)EmptyMemoryTracker.INSTANCE).get(base + 1L, into);
        Assertions.assertThat((byte)into[0]).isEqualTo((byte)0);
        Assertions.assertThat((int)factory.newIntArray(10L, 1, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE).get(base + 1L)).isEqualTo(1);
        Assertions.assertThat((long)factory.newLongArray(10L, 1L, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE).get(base + 1L)).isEqualTo(1L);
    }

    @Test
    void heapArrayShouldThrowOnTooLargeArraySize() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> NumberArrayFactories.HEAP.newByteArray(0x3FFFFFFFL, new byte[10], 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isInstanceOf(ArithmeticException.class)).hasMessage("integer overflow");
    }

    private static /* synthetic */ void lambda$shouldThrowOomOnNotEnoughMemory$0(NumberArrayFactory factory) throws Throwable {
        factory.newLongArray(1024L, -1L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private static class FailureMonitor
    implements NumberArrayFactory.Monitor {
        private long memory;
        private NumberArrayFactory successfulFactory;
        private Iterable<NumberArrayFactory.AllocationFailure> attemptedAllocationFailures;

        private FailureMonitor() {
        }

        public void allocationSuccessful(long memory, NumberArrayFactory successfulFactory, Iterable<NumberArrayFactory.AllocationFailure> attemptedAllocationFailures) {
            this.memory = memory;
            this.successfulFactory = successfulFactory;
            this.attemptedAllocationFailures = attemptedAllocationFailures;
        }
    }
}

