/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.utils.TestDirectory;

public class NumberArrayPageCacheTestSupport {
    static Fixture prepareDirectoryAndPageCache(Class<?> testClass) throws IOException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        TestDirectory testDirectory = TestDirectory.testDirectory(testClass, (FileSystemAbstraction)fileSystem);
        Path dir = testDirectory.prepareDirectoryForTest("test");
        ThreadPoolJobScheduler scheduler = new ThreadPoolJobScheduler();
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY);
        PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (JobScheduler)scheduler, (PageCacheTracer)PageCacheTracer.NULL, (MuninnPageCache.Configuration)MuninnPageCache.config((int)1024));
        return new Fixture(pageCache, (FileSystemAbstraction)fileSystem, dir, scheduler, contextFactory);
    }

    public static class Fixture
    implements AutoCloseable {
        public final PageCache pageCache;
        public final FileSystemAbstraction fileSystem;
        public final CursorContextFactory contextFactory;
        public final Path directory;
        private final ThreadPoolJobScheduler scheduler;

        private Fixture(PageCache pageCache, FileSystemAbstraction fileSystem, Path directory, ThreadPoolJobScheduler scheduler, CursorContextFactory contextFactory) {
            this.pageCache = pageCache;
            this.fileSystem = fileSystem;
            this.directory = directory;
            this.scheduler = scheduler;
            this.contextFactory = contextFactory;
        }

        @Override
        public void close() throws Exception {
            this.pageCache.close();
            this.scheduler.close();
            this.fileSystem.close();
        }
    }
}

