/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.batchimport.cache.NumberArrayPageCacheTestSupport;
import org.neo4j.test.RandomSupport;

class NumberArrayTest
extends NumberArrayPageCacheTestSupport {
    private static final RandomSupport random = new RandomSupport();
    private static final int INDEXES = 50000;
    private static final int CHUNK_SIZE = Integer.max(1, 500);
    private static NumberArrayPageCacheTestSupport.Fixture fixture;

    NumberArrayTest() {
    }

    @BeforeAll
    static void setUp() throws IOException {
        fixture = NumberArrayTest.prepareDirectoryAndPageCache(NumberArrayTest.class);
        random.reset();
    }

    @AfterAll
    static void tearDown() throws Exception {
        fixture.close();
    }

    @TestFactory
    Stream<DynamicTest> shouldGetAndSetRandomItems() {
        ThrowingConsumer throwingConsumer = data -> {
            try (Object array = data.array;){
                int i;
                HashMap<Integer, Object> key = new HashMap<Integer, Object>();
                Reader reader = data.reader;
                Object defaultValue = reader.read(array, 0);
                for (i = 0; i < 100000; ++i) {
                    int index = random.nextInt(50000);
                    Object value = data.valueGenerator.apply(random);
                    data.writer.write(i % 2 == 0 ? array : array.at((long)index), index, value);
                    key.put(index, value);
                }
                NumberArrayTest.assertAllValues(key, defaultValue, reader, array);
                for (i = 0; i < 25000; ++i) {
                    int toIndex;
                    int fromIndex = random.nextInt(50000);
                    while ((toIndex = random.nextInt(50000)) == fromIndex) {
                    }
                    Object fromValue = reader.read(array, fromIndex);
                    Object toValue = reader.read(array, toIndex);
                    key.put(fromIndex, toValue);
                    key.put(toIndex, fromValue);
                    array.swap((long)fromIndex, (long)toIndex);
                }
                NumberArrayTest.assertAllValues(key, defaultValue, reader, array);
            }
        };
        return DynamicTest.stream(NumberArrayTest.arrays().iterator(), data -> data.name, (ThrowingConsumer)throwingConsumer);
    }

    /*
     * Exception decompiling
     */
    public static Collection<NumberArrayTestData> arrays() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] defaultByteArray(int length) {
        byte[] result = new byte[length];
        Arrays.fill(result, (byte)-1);
        return result;
    }

    private static <N extends NumberArray<N>> NumberArrayTestData arrayData(String name, N array, Function<RandomSupport, Object> valueGenerator, Writer<N> writer, Reader<N> reader) {
        return new NumberArrayTestData<N>(name, array, valueGenerator, writer, reader);
    }

    private static void assertAllValues(Map<Integer, Object> key, Object defaultValue, Reader reader, NumberArray array) {
        for (int index = 0; index < 50000; ++index) {
            Object value = reader.read(index % 2 == 0 ? array : array.at((long)index), index);
            Object expectedValue = key.getOrDefault(index, defaultValue);
            if (value instanceof long[]) {
                Assertions.assertArrayEquals((long[])((long[])expectedValue), (long[])((long[])value), (String)("index " + index));
                continue;
            }
            Assertions.assertEquals((Object)expectedValue, (Object)value, (String)("index " + index));
        }
    }

    private static /* synthetic */ Object lambda$arrays$18(ByteArray array, int index) {
        return new long[]{array.getLong((long)index, 0), array.getInt((long)index, 8), array.getShort((long)index, 12), array.getByte((long)index, 14)};
    }

    private static /* synthetic */ void lambda$arrays$17(ByteArray array, int index, Object value) {
        long[] values = (long[])value;
        array.setLong((long)index, 0, values[0]);
        array.setInt((long)index, 8, (int)values[1]);
        array.setShort((long)index, 12, (short)values[2]);
        array.setByte((long)index, 14, (byte)values[3]);
    }

    @FunctionalInterface
    static interface Writer<N extends NumberArray<N>> {
        public void write(N var1, int var2, Object var3);
    }

    @FunctionalInterface
    static interface Reader<N extends NumberArray<N>> {
        public Object read(N var1, int var2);
    }

    private static class NumberArrayTestData<T extends NumberArray<T>> {
        private final String name;
        private final T array;
        private final Function<RandomSupport, Object> valueGenerator;
        private final Writer<T> writer;
        private final Reader<T> reader;

        NumberArrayTestData(String name, T array, Function<RandomSupport, Object> valueGenerator, Writer<T> writer, Reader<T> reader) {
            this.name = name;
            this.array = array;
            this.valueGenerator = valueGenerator;
            this.writer = writer;
            this.reader = reader;
        }
    }
}

