/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.nio.file.Path;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.PageCacheArrayFactoryMonitor;
import org.neo4j.internal.batchimport.cache.PageCachedNumberArrayFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;

class PageCacheArrayFactoryMonitorTest {
    private final PageCachedNumberArrayFactory factory = new PageCachedNumberArrayFactory((PageCache)Mockito.mock(PageCache.class), new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY), Path.of("storeDir", new String[0]), (InternalLog)NullLog.getInstance(), "neo4j");
    private final PageCacheArrayFactoryMonitor monitor = new PageCacheArrayFactoryMonitor();

    PageCacheArrayFactoryMonitorTest() {
    }

    @Test
    void shouldComposeFailureDescriptionForFailedCandidates() {
        this.monitor.allocationSuccessful(123L, (NumberArrayFactory)this.factory, Arrays.asList(new NumberArrayFactory.AllocationFailure((Throwable)new OutOfMemoryError("OOM1"), NumberArrayFactories.HEAP), new NumberArrayFactory.AllocationFailure((Throwable)new OutOfMemoryError("OOM2"), NumberArrayFactories.OFF_HEAP)));
        String failure = this.monitor.pageCacheAllocationOrNull();
        Assertions.assertThat((String)failure).contains(new CharSequence[]{"OOM1"});
        Assertions.assertThat((String)failure).contains(new CharSequence[]{"OOM2"});
    }

    @Test
    void shouldClearFailureStateAfterAccessorCall() {
        this.monitor.allocationSuccessful(123L, (NumberArrayFactory)this.factory, Arrays.asList(new NumberArrayFactory.AllocationFailure((Throwable)new OutOfMemoryError("OOM1"), NumberArrayFactories.HEAP), new NumberArrayFactory.AllocationFailure((Throwable)new OutOfMemoryError("OOM2"), NumberArrayFactories.OFF_HEAP)));
        String failure = this.monitor.pageCacheAllocationOrNull();
        String secondCall = this.monitor.pageCacheAllocationOrNull();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)failure);
        org.junit.jupiter.api.Assertions.assertNull((Object)secondCall);
    }

    @Test
    void shouldReturnNullFailureOnNoFailure() {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.monitor.pageCacheAllocationOrNull());
    }
}

