/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.batchimport.cache.PageCacheByteArray;
import org.neo4j.internal.batchimport.cache.PageCacheNumberArrayConcurrencyTest;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class PageCacheByteArrayConcurrencyTest
extends PageCacheNumberArrayConcurrencyTest {
    @Override
    protected Runnable wholeFileRacer(NumberArray array, int contestant) {
        return new WholeFileRacer((ByteArray)array);
    }

    @Override
    protected Runnable fileRangeRacer(NumberArray array, int contestant) {
        return new FileRangeRacer((ByteArray)array, contestant);
    }

    protected ByteArray getNumberArray(PagedFile file) throws IOException {
        return new PageCacheByteArray(file, new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY), 100L, new byte[]{-1, -1, -1, -1}, 0L);
    }

    private static class WholeFileRacer
    implements Runnable {
        private final ByteArray array;

        WholeFileRacer(ByteArray array) {
            this.array = array;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (int i = 0; i < 100; ++i) {
                    byte[] value = new byte[]{1, 2, 3, 4};
                    this.array.set((long)i, value);
                    byte[] actual = new byte[4];
                    this.array.get((long)i, actual);
                    Assertions.assertArrayEquals((byte[])value, (byte[])actual);
                }
            }
        }
    }

    private class FileRangeRacer
    implements Runnable {
        private final ByteArray array;
        private final int contestant;

        FileRangeRacer(ByteArray array, int contestant) {
            this.array = array;
            this.contestant = contestant;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (int i = this.contestant; i < 100; i += 10) {
                    byte[] value = new byte[4];
                    byte[] actual = new byte[4];
                    PageCacheByteArrayConcurrencyTest.this.random.nextBytes(value);
                    this.array.set((long)i, value);
                    this.array.get((long)i, actual);
                    Assertions.assertArrayEquals((byte[])value, (byte[])actual);
                }
            }
        }
    }
}

