/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.batchimport.cache.PageCacheIntArray;
import org.neo4j.internal.batchimport.cache.PageCacheNumberArrayConcurrencyTest;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class PageCacheIntArrayConcurrencyTest
extends PageCacheNumberArrayConcurrencyTest {
    @Override
    protected Runnable wholeFileRacer(NumberArray array, int contestant) {
        return new WholeFileRacer((IntArray)((PageCacheIntArray)array));
    }

    @Override
    protected Runnable fileRangeRacer(NumberArray array, int contestant) {
        return new FileRangeRacer((IntArray)((PageCacheIntArray)array), contestant);
    }

    protected PageCacheIntArray getNumberArray(PagedFile file) throws IOException {
        return new PageCacheIntArray(file, new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY), 100L, 0L, 0L);
    }

    private static class WholeFileRacer
    implements Runnable {
        private final IntArray array;

        WholeFileRacer(IntArray array) {
            this.array = array;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (int i = 0; i < 100; ++i) {
                    this.array.set((long)i, i);
                    Assertions.assertEquals((int)i, (int)this.array.get((long)i));
                }
            }
        }
    }

    private class FileRangeRacer
    implements Runnable {
        private final IntArray array;
        private final int contestant;

        FileRangeRacer(IntArray array, int contestant) {
            this.array = array;
            this.contestant = contestant;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (int i = this.contestant; i < 100; i += 10) {
                    int value = PageCacheIntArrayConcurrencyTest.this.random.nextInt();
                    this.array.set((long)i, value);
                    Assertions.assertEquals((int)value, (int)this.array.get((long)i));
                }
            }
        }
    }
}

