/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.internal.batchimport.cache.PageCacheLongArray;
import org.neo4j.internal.batchimport.cache.PageCacheNumberArrayConcurrencyTest;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class PageCacheLongArrayConcurrencyTest
extends PageCacheNumberArrayConcurrencyTest {
    @Override
    protected Runnable wholeFileRacer(NumberArray array, int contestant) {
        return new WholeFileRacer((LongArray)((PageCacheLongArray)array));
    }

    @Override
    protected Runnable fileRangeRacer(NumberArray array, int contestant) {
        return new FileRangeRacer((LongArray)((PageCacheLongArray)array), contestant);
    }

    protected PageCacheLongArray getNumberArray(PagedFile file) throws IOException {
        return new PageCacheLongArray(file, new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY), 100L, 0L, 0L);
    }

    private static class WholeFileRacer
    implements Runnable {
        private final LongArray array;

        WholeFileRacer(LongArray array) {
            this.array = array;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (long i = 0L; i < 100L; ++i) {
                    this.array.set(i, i);
                    Assertions.assertEquals((long)i, (long)this.array.get(i));
                }
            }
        }
    }

    private class FileRangeRacer
    implements Runnable {
        private final LongArray array;
        private final int contestant;

        FileRangeRacer(LongArray array, int contestant) {
            this.array = array;
            this.contestant = contestant;
        }

        @Override
        public void run() {
            for (int o = 0; o < 2000; ++o) {
                for (long i = (long)this.contestant; i < 100L; i += 10L) {
                    long value = PageCacheLongArrayConcurrencyTest.this.random.nextLong();
                    this.array.set(i, value);
                    Assertions.assertEquals((long)value, (long)this.array.get(i));
                }
            }
        }
    }
}

