/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.collections.impl.factory.Sets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.PageCacheLongArray;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
@ExtendWith(value={RandomExtension.class})
class PageCacheLongArrayTest {
    private static final int COUNT = 1000000;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private PageCache pageCache;
    @Inject
    private RandomSupport random;

    PageCacheLongArrayTest() {
    }

    @Test
    void verifyPageCacheLongArray() throws Exception {
        PagedFile file = this.pageCache.map(this.testDirectory.file("file"), this.pageCache.pageSize(), "neo4j", Sets.immutable.of((Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.DELETE_ON_CLOSE));
        try (PageCacheLongArray array = new PageCacheLongArray(file, new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY), 1000000L, 0L, 0L);){
            this.verifyBehaviour((LongArray)array);
        }
    }

    @Test
    void verifyChunkingArrayWithPageCacheLongArray() {
        Path directory = this.testDirectory.homePath();
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY);
        NumberArrayFactory numberArrayFactory = NumberArrayFactories.auto((PageCache)this.pageCache, (CursorContextFactory)contextFactory, (Path)directory, (boolean)false, (NumberArrayFactory.Monitor)NumberArrayFactories.NO_MONITOR, (InternalLog)NullLog.getInstance(), (String)"neo4j");
        try (LongArray array = numberArrayFactory.newDynamicLongArray(1000L, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.verifyBehaviour(array);
        }
    }

    private void verifyBehaviour(LongArray array) {
        int i;
        for (i = 0; i < 1000000; ++i) {
            array.set((long)i, (long)i);
        }
        for (i = 0; i < 1000000; ++i) {
            Assertions.assertEquals((long)i, (long)array.get((long)i));
        }
        int stride = 12345678;
        int next = this.random.nextInt(1000000);
        for (int i2 = 0; i2 < 1000000; ++i2) {
            Assertions.assertEquals((long)next, (long)array.get((long)next));
            next = (next + stride) % 1000000;
        }
    }
}

