/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.util.function.BiFunction;
import org.eclipse.collections.impl.factory.Sets;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.batchimport.cache.NumberArray;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
@ExtendWith(value={RandomExtension.class})
public abstract class PageCacheNumberArrayConcurrencyTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private PageCache pageCache;
    @Inject
    protected RandomSupport random;
    protected static final int COUNT = 100;
    static final int LAPS = 2000;
    static final int CONTESTANTS = 10;

    @Test
    void shouldHandleConcurrentAccessToSameData() throws Throwable {
        this.doRace(this::wholeFileRacer);
    }

    @Test
    void shouldHandleConcurrentAccessToDifferentData() throws Throwable {
        this.doRace(this::fileRangeRacer);
    }

    private void doRace(BiFunction<NumberArray, Integer, Runnable> contestantCreator) throws Throwable {
        PagedFile file = this.pageCache.map(this.testDirectory.file("file"), this.pageCache.pageSize(), "neo4j", Sets.immutable.of((Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.DELETE_ON_CLOSE));
        Race race = new Race();
        try (NumberArray array = this.getNumberArray(file);){
            for (int i = 0; i < 10; ++i) {
                race.addContestant(contestantCreator.apply(array, i));
            }
            race.go();
        }
    }

    protected abstract Runnable fileRangeRacer(NumberArray var1, int var2);

    protected abstract NumberArray getNumberArray(PagedFile var1) throws IOException;

    protected abstract Runnable wholeFileRacer(NumberArray var1, int var2);
}

