/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import java.nio.file.Path;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.batchimport.cache.PageCachedNumberArrayFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
class PageCachedNumberArrayFactoryTest {
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory directory;
    private final CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY);

    PageCachedNumberArrayFactoryTest() {
    }

    @Test
    void shouldLogAllocationOnIntArray() {
        InternalLog log = (InternalLog)Mockito.mock(InternalLog.class);
        Path dir = this.directory.directory("cache");
        PageCachedNumberArrayFactory factory = new PageCachedNumberArrayFactory(this.pageCache, this.contextFactory, dir, log, "neo4j");
        factory.newIntArray(1000L, -1, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE).close();
        ((InternalLog)Mockito.verify((Object)log)).info(ArgumentMatchers.contains((String)"Using page-cache backed caching"));
    }

    @Test
    void shouldLogAllocationOnLongArray() {
        InternalLog log = (InternalLog)Mockito.mock(InternalLog.class);
        Path dir = this.directory.directory("cache");
        PageCachedNumberArrayFactory factory = new PageCachedNumberArrayFactory(this.pageCache, this.contextFactory, dir, log, "neo4j");
        factory.newLongArray(1000L, -1L, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE).close();
        ((InternalLog)Mockito.verify((Object)log)).info(ArgumentMatchers.contains((String)"Using page-cache backed caching"));
    }

    @Test
    void shouldLogAllocationOnByteArray() {
        InternalLog log = (InternalLog)Mockito.mock(InternalLog.class);
        Path dir = this.directory.directory("cache");
        PageCachedNumberArrayFactory factory = new PageCachedNumberArrayFactory(this.pageCache, this.contextFactory, dir, log, "neo4j");
        factory.newByteArray(1000L, new byte[4], 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE).close();
        ((InternalLog)Mockito.verify((Object)log)).info(ArgumentMatchers.contains((String)"Using page-cache backed caching"));
    }
}

