/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.idmapping.string.BigIdTracker;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class BigIdTrackerTest {
    @Inject
    private RandomSupport random;

    BigIdTrackerTest() {
    }

    @Test
    void shouldKeepIdsAndMarkDuplicates() {
        int length = 10000;
        try (BigIdTracker tracker = new BigIdTracker(NumberArrayFactories.HEAP.newByteArray((long)length, BigIdTracker.DEFAULT_VALUE, (MemoryTracker)EmptyMemoryTracker.INSTANCE));){
            int i;
            long[] values = new long[length];
            boolean[] marks = new boolean[length];
            for (i = 0; i < length; ++i) {
                values[i] = this.random.nextLong(0x4000000000L);
                tracker.set((long)i, values[i]);
                if (!this.random.nextBoolean()) continue;
                tracker.markAsDuplicate((long)i);
                marks[i] = true;
            }
            for (i = 0; i < length; ++i) {
                Assertions.assertEquals((long)values[i], (long)tracker.get((long)i));
                Assertions.assertEquals((Object)marks[i], (Object)tracker.isMarkedAsDuplicate((long)i));
            }
        }
    }
}

