/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.function.Factory;
import org.neo4j.internal.batchimport.PropertyValueLookup;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.string.BigIdTracker;
import org.neo4j.internal.batchimport.cache.idmapping.string.CollisionValues;
import org.neo4j.internal.batchimport.cache.idmapping.string.ControlledEncoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.EncodingIdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.string.IntTracker;
import org.neo4j.internal.batchimport.cache.idmapping.string.LongCollisionValues;
import org.neo4j.internal.batchimport.cache.idmapping.string.LongEncoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.internal.batchimport.cache.idmapping.string.Radix;
import org.neo4j.internal.batchimport.cache.idmapping.string.StringCollisionValues;
import org.neo4j.internal.batchimport.cache.idmapping.string.StringEncoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.TrackerFactory;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
public class EncodingIdMapperTest {
    @Inject
    private RandomSupport random;
    private final Groups groups = new Groups();
    private final Group globalGroup = this.groups.getOrCreate(null);
    private static final TrackerFactory RANDOM_TRACKER_FACTORY = (arrayFactory, size) -> System.currentTimeMillis() % 2L == 0L ? new IntTracker(arrayFactory.newIntArray(size, -1, (MemoryTracker)EmptyMemoryTracker.INSTANCE)) : new BigIdTracker(arrayFactory.newByteArray(size, BigIdTracker.DEFAULT_VALUE, (MemoryTracker)EmptyMemoryTracker.INSTANCE));

    private static Stream<Integer> data() {
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(1);
        data.add(2);
        int bySystem = Runtime.getRuntime().availableProcessors() - 1;
        if (bySystem > 2) {
            data.add(bySystem);
        }
        return data.stream();
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldHandleGreatAmountsOfStuff(int processors) {
        long nodeId;
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, processors);
        PropertyValueLookup inputIdLookup = String::valueOf;
        int count = 300000;
        for (nodeId = 0L; nodeId < (long)count; ++nodeId) {
            idMapper.put(inputIdLookup.lookupProperty(nodeId), nodeId, this.globalGroup);
        }
        idMapper.prepare(inputIdLookup, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (nodeId = 0L; nodeId < (long)count; ++nodeId) {
            Object id = inputIdLookup.lookupProperty(nodeId);
            if (idMapper.get(id, this.globalGroup) != -1L) continue;
            org.junit.jupiter.api.Assertions.fail((String)("Couldn't find " + id + " even though I added it just previously"));
        }
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldReturnExpectedValueForNotFound(int processors) {
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, processors);
        idMapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        long id = idMapper.get((Object)"123", this.globalGroup);
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)id);
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldReportyProgressForSortAndDetect(int processors) {
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, processors);
        ProgressListener progress = (ProgressListener)Mockito.mock(ProgressListener.class);
        idMapper.prepare(null, (Collector)Mockito.mock(Collector.class), progress);
        long id = idMapper.get((Object)"123", this.globalGroup);
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)id);
        ((ProgressListener)Mockito.verify((Object)progress, (VerificationMode)Mockito.times((int)3))).close();
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldEncodeShortStrings(int processors) {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, processors);
        mapper.put((Object)"123", 0L, this.globalGroup);
        mapper.put((Object)"456", 1L, this.globalGroup);
        mapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)mapper.get((Object)"456", this.globalGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)mapper.get((Object)"123", this.globalGroup));
    }

    @Test
    public void shouldDiscardEmptyStringWhenEmptyNotMapped() {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, 1);
        mapper.put((Object)"1", 1L, this.globalGroup);
        mapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)mapper.get((Object)"1", this.globalGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)mapper.get((Object)"", this.globalGroup));
    }

    @Test
    public void shouldFindEncodedShortStringsWithNonAscii() {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, 1);
        mapper.put((Object)"P_\u00c9vora", 0L, this.globalGroup);
        mapper.put((Object)"P_Set\u00fabal", 1L, this.globalGroup);
        mapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)mapper.get((Object)"P_Set\u00fabal", this.globalGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)mapper.get((Object)"P_\u00c9vora", this.globalGroup));
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldEncodeSmallSetOfRandomData(int processors) {
        int nodeId;
        int size = this.random.nextInt(10000) + 2;
        ValueType type = ValueType.values()[this.random.nextInt(ValueType.values().length)];
        IdMapper mapper = this.mapper(type.encoder(), type.radix(), EncodingIdMapper.NO_MONITOR, processors);
        ValueGenerator values = new ValueGenerator(type.data(this.random.random()));
        for (nodeId = 0; nodeId < size; ++nodeId) {
            mapper.put(values.lookupProperty(nodeId), (long)nodeId, this.globalGroup);
        }
        mapper.prepare((PropertyValueLookup)values, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (nodeId = 0; nodeId < size; ++nodeId) {
            Object value = values.values.get(nodeId);
            org.junit.jupiter.api.Assertions.assertEquals((long)nodeId, (long)mapper.get(value, this.globalGroup), (String)("Expected " + value + " to map to " + nodeId));
        }
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldReportCollisionsForSameInputId(int processors) {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, processors);
        PropertyValueLookup values = EncodingIdMapperTest.values("10", "9", "10");
        for (int i = 0; i < 3; ++i) {
            mapper.put(values.lookupProperty((long)i), (long)i, this.globalGroup);
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(values, collector, ProgressListener.NONE);
        ((Collector)Mockito.verify((Object)collector)).collectDuplicateNode((Object)"10", 2L, this.globalGroup);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldCopeWithCollisionsBasedOnDifferentInputIds(int processors) {
        EncodingIdMapper.Monitor monitor = (EncodingIdMapper.Monitor)Mockito.mock(EncodingIdMapper.Monitor.class);
        Encoder encoder = (Encoder)Mockito.mock(Encoder.class);
        Mockito.when((Object)encoder.encode(ArgumentMatchers.any())).thenReturn((Object)12345L);
        IdMapper mapper = this.mapper(encoder, (Factory<Radix>)Radix.STRING, monitor, processors);
        PropertyValueLookup ids = EncodingIdMapperTest.values("10", "9");
        for (int i = 0; i < 2; ++i) {
            mapper.put(ids.lookupProperty((long)i), (long)i, this.globalGroup);
        }
        ProgressListener progress = (ProgressListener)Mockito.mock(ProgressListener.class);
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, progress);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        ((EncodingIdMapper.Monitor)Mockito.verify((Object)monitor)).numberOfCollisions(2L);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)mapper.get((Object)"10", this.globalGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)mapper.get((Object)"9", this.globalGroup));
        ((ProgressListener)Mockito.verify((Object)progress, (VerificationMode)Mockito.times((int)7))).close();
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldCopeWithMixedActualAndAccidentalCollisions(int processors) {
        EncodingIdMapper.Monitor monitor = (EncodingIdMapper.Monitor)Mockito.mock(EncodingIdMapper.Monitor.class);
        Encoder encoder = (Encoder)Mockito.mock(Encoder.class);
        String a = "a";
        String b = "b";
        String c = "c";
        String a2 = "a";
        String e = "e";
        String f = "f";
        Mockito.when((Object)encoder.encode((Object)a)).thenReturn((Object)1L);
        Mockito.when((Object)encoder.encode((Object)b)).thenReturn((Object)1L);
        Mockito.when((Object)encoder.encode((Object)c)).thenReturn((Object)3L);
        Mockito.when((Object)encoder.encode((Object)a2)).thenReturn((Object)1L);
        Mockito.when((Object)encoder.encode((Object)e)).thenReturn((Object)2L);
        Mockito.when((Object)encoder.encode((Object)f)).thenReturn((Object)1L);
        Group groupA = this.groups.getOrCreate("A");
        Group groupB = this.groups.getOrCreate("B");
        IdMapper mapper = this.mapper(encoder, (Factory<Radix>)Radix.STRING, monitor, processors);
        PropertyValueLookup ids = EncodingIdMapperTest.values("a", "b", "c", "a", "e", "f");
        Group[] groups = new Group[]{groupA, groupA, groupA, groupB, groupB, groupB};
        for (int i = 0; i < 6; ++i) {
            mapper.put(ids.lookupProperty((long)i), (long)i, groups[i]);
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, (ProgressListener)Mockito.mock(ProgressListener.class));
        ((EncodingIdMapper.Monitor)Mockito.verify((Object)monitor)).numberOfCollisions(4L);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)mapper.get((Object)a, groupA));
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)mapper.get((Object)b, groupA));
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)mapper.get((Object)c, groupA));
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)mapper.get((Object)a2, groupB));
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)mapper.get((Object)e, groupB));
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)mapper.get((Object)f, groupB));
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldBeAbleToHaveDuplicateInputIdButInDifferentGroups(int processors) {
        EncodingIdMapper.Monitor monitor = (EncodingIdMapper.Monitor)Mockito.mock(EncodingIdMapper.Monitor.class);
        Group firstGroup = this.groups.getOrCreate("first");
        Group secondGroup = this.groups.getOrCreate("second");
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, monitor, processors);
        PropertyValueLookup ids = EncodingIdMapperTest.values("10", "9", "10");
        int id = 0;
        mapper.put(ids.lookupProperty((long)id), (long)id++, firstGroup);
        mapper.put(ids.lookupProperty((long)id), (long)id++, firstGroup);
        mapper.put(ids.lookupProperty((long)id), (long)id, secondGroup);
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, ProgressListener.NONE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        ((EncodingIdMapper.Monitor)Mockito.verify((Object)monitor)).numberOfCollisions(0L);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)mapper.get((Object)"10", firstGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)mapper.get((Object)"9", firstGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)mapper.get((Object)"10", secondGroup));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)mapper.leftOverDuplicateNodesIds().hasNext());
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldOnlyFindInputIdsInSpecificGroup(int processors) {
        Group firstGroup = this.groups.getOrCreate("first");
        Group secondGroup = this.groups.getOrCreate("second");
        Group thirdGroup = this.groups.getOrCreate("third");
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, processors);
        PropertyValueLookup ids = EncodingIdMapperTest.values("8", "9", "10");
        int id = 0;
        mapper.put(ids.lookupProperty((long)id), (long)id++, firstGroup);
        mapper.put(ids.lookupProperty((long)id), (long)id++, secondGroup);
        mapper.put(ids.lookupProperty((long)id), (long)id, thirdGroup);
        mapper.prepare(ids, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)mapper.get((Object)"8", firstGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)mapper.get((Object)"8", secondGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)mapper.get((Object)"8", thirdGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)mapper.get((Object)"9", firstGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)mapper.get((Object)"9", secondGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)mapper.get((Object)"9", thirdGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)mapper.get((Object)"10", firstGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)mapper.get((Object)"10", secondGroup));
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)mapper.get((Object)"10", thirdGroup));
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldHandleManyGroups(int processors) {
        int i;
        int size = 256;
        for (int i2 = 0; i2 < size; ++i2) {
            this.groups.getOrCreate("" + i2);
        }
        IdMapper mapper = this.mapper((Encoder)new LongEncoder(), (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR, processors);
        for (i = 0; i < size; ++i) {
            mapper.put((Object)i, (long)i, this.groups.get("" + i));
        }
        mapper.prepare(null, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (i = 0; i < size; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((long)i, (long)mapper.get((Object)i, this.groups.get("" + i)));
        }
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldDetectCorrectDuplicateInputIdsWhereManyAccidentalInManyGroups(int processors) {
        ControlledEncoder encoder = new ControlledEncoder((Encoder)new LongEncoder());
        int idsPerGroup = 20;
        int groupCount = 5;
        for (int i = 0; i < groupCount; ++i) {
            this.groups.getOrCreate("Group " + i);
        }
        EncodingIdMapper mapper = this.mapper(encoder, (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR, ParallelSort.DEFAULT, numberOfCollisions -> new LongCollisionValues(NumberArrayFactories.HEAP, numberOfCollisions, (MemoryTracker)EmptyMemoryTracker.INSTANCE), processors);
        Function<Long, Integer> nodeIdToGroupId = nodeId -> Math.toIntExact(nodeId / 20L);
        PropertyValueLookup ids = nodeId -> {
            int groupId = (Integer)nodeIdToGroupId.apply(nodeId);
            if (nodeId % 20L < 2L) {
                encoder.useThisIdToEncodeNoMatterWhatComesIn(1234567L);
                return nodeId % 20L;
            }
            encoder.useThisIdToEncodeNoMatterWhatComesIn(123456 - groupId);
            return nodeId;
        };
        int count = 20 * groupCount;
        for (long nodeId2 = 0L; nodeId2 < (long)count; ++nodeId2) {
            Integer groupId = nodeIdToGroupId.apply(nodeId2);
            Object inputId = ids.lookupProperty(nodeId2);
            mapper.put(inputId, nodeId2, this.groups.get(groupId.intValue()));
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(ids, collector, ProgressListener.NONE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        for (long nodeId3 = 0L; nodeId3 < (long)count; ++nodeId3) {
            Integer groupId = nodeIdToGroupId.apply(nodeId3);
            Object inputId = ids.lookupProperty(nodeId3);
            long actual = mapper.get(inputId, this.groups.get(groupId.intValue()));
            if (actual != nodeId3) {
                mapper.dumpState(System.err);
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)nodeId3, (long)actual);
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collector});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)mapper.leftOverDuplicateNodesIds().hasNext());
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldHandleHolesInIdSequence(int processors) {
        IdMapper mapper = this.mapper((Encoder)new LongEncoder(), (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR, processors);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < 100; ++i) {
            if (this.random.nextBoolean()) continue;
            Long id = i;
            ids.add(id);
            mapper.put((Object)id, (long)i, this.globalGroup);
        }
        mapper.prepare(EncodingIdMapperTest.values(ids.toArray()), (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        for (Long id : ids) {
            org.junit.jupiter.api.Assertions.assertEquals((long)id, (long)mapper.get((Object)id, this.globalGroup));
        }
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldHandleLargeAmountsOfDuplicateNodeIds(int processors) {
        IdMapper mapper = this.mapper((Encoder)new LongEncoder(), (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR, processors);
        long nodeId = 0L;
        int high = 10;
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int run = 0; run < 2; ++run) {
            for (long i = 0L; i < (long)(high / 2); ++i) {
                ids.add((long)high - (i + 1L));
                ids.add(i);
            }
        }
        for (Object e : ids) {
            mapper.put(e, nodeId++, this.globalGroup);
        }
        Collector collector = (Collector)Mockito.mock(Collector.class);
        mapper.prepare(EncodingIdMapperTest.values(ids.toArray()), collector, ProgressListener.NONE);
        ((Collector)Mockito.verify((Object)collector, (VerificationMode)Mockito.times((int)high))).collectDuplicateNode(ArgumentMatchers.any(Object.class), ArgumentMatchers.anyLong(), (Group)ArgumentMatchers.any());
        org.junit.jupiter.api.Assertions.assertEquals((int)high, (int)PrimitiveLongCollections.count((LongIterator)mapper.leftOverDuplicateNodesIds()));
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldDetectLargeAmountsOfCollisions(int processors) {
        IdMapper mapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, processors);
        int count = 20000;
        ArrayList<String> ids = new ArrayList<String>();
        long id = 0L;
        for (int elements = 0; elements < count; ++elements) {
            String inputId = UUID.randomUUID().toString();
            for (int i = 0; i < 2; ++i) {
                ids.add(inputId);
                mapper.put((Object)inputId, id++, this.globalGroup);
            }
        }
        CountingCollector collector = new CountingCollector();
        mapper.prepare(EncodingIdMapperTest.values(ids.toArray()), (Collector)collector, ProgressListener.NONE);
        org.junit.jupiter.api.Assertions.assertEquals((int)count, (int)collector.count);
    }

    @ParameterizedTest(name="processors:{0}")
    @MethodSource(value={"data"})
    public void shouldPutFromMultipleThreads(int processors) throws Throwable {
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, processors);
        AtomicLong highNodeId = new AtomicLong();
        int batchSize = 1234;
        Race race = new Race();
        PropertyValueLookup inputIdLookup = String::valueOf;
        int countPerThread = 30000;
        race.addContestants(processors, () -> {
            int cursor = batchSize;
            long nextNodeId = 0L;
            for (int j = 0; j < countPerThread; ++j) {
                long nodeId;
                if (cursor == batchSize) {
                    nextNodeId = highNodeId.getAndAdd(batchSize);
                    cursor = 0;
                }
                ++nextNodeId;
                ++cursor;
                idMapper.put(inputIdLookup.lookupProperty(nodeId), nodeId, this.globalGroup);
            }
        });
        race.go();
        idMapper.prepare(inputIdLookup, (Collector)Mockito.mock(Collector.class), ProgressListener.NONE);
        int count = processors * countPerThread;
        int countWithGapsWorstCase = count + batchSize * processors;
        int correctHits = 0;
        for (long nodeId = 0L; nodeId < (long)countWithGapsWorstCase; ++nodeId) {
            long result = idMapper.get(inputIdLookup.lookupProperty(nodeId), this.globalGroup);
            if (result == -1L) continue;
            org.junit.jupiter.api.Assertions.assertEquals((long)nodeId, (long)result);
            ++correctHits;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)count, (int)correctHits);
    }

    @Test
    void shouldSkipNullValues() {
        final MutableLong highDataIndex = new MutableLong();
        final MutableLong highTrackerIndex = new MutableLong();
        EncodingIdMapper.Monitor monitor = new EncodingIdMapper.Monitor(){

            public void preparing(long highestSetDataIndex, long highestSetTrackerIndex) {
                highDataIndex.setValue(highestSetDataIndex);
                highTrackerIndex.setValue(highestSetTrackerIndex);
            }
        };
        IdMapper idMapper = this.mapper((Encoder)new LongEncoder(), (Factory<Radix>)Radix.LONG, monitor, 4);
        long count = 1000L;
        for (long id = 0L; id < count; ++id) {
            long nodeId2 = id * 2L;
            idMapper.put((Object)id, nodeId2, this.globalGroup);
        }
        idMapper.prepare(nodeId -> {
            throw new RuntimeException("Should not be called");
        }, Collector.EMPTY, ProgressListener.NONE);
        org.junit.jupiter.api.Assertions.assertEquals((long)((count - 1L) * 2L), (long)highDataIndex.longValue());
        org.junit.jupiter.api.Assertions.assertEquals((long)(count - 1L), (long)highTrackerIndex.longValue());
    }

    @Test
    void shouldCompleteQuicklyForMostlyGapValues() {
        int nThreads = 4;
        LongEncoder encoder = new LongEncoder();
        final AtomicInteger numberOfComparisons = new AtomicInteger();
        ParallelSort.Comparator comparator = new ParallelSort.Comparator(){

            public boolean lt(long left, long pivot) {
                numberOfComparisons.incrementAndGet();
                return ParallelSort.DEFAULT.lt(left, pivot);
            }

            public boolean ge(long right, long pivot) {
                numberOfComparisons.incrementAndGet();
                return ParallelSort.DEFAULT.ge(right, pivot);
            }

            public long dataValue(long dataValue) {
                return ParallelSort.DEFAULT.dataValue(dataValue);
            }
        };
        EncodingIdMapper idMapper = this.mapper((Encoder)encoder, (Factory<Radix>)Radix.LONG, EncodingIdMapper.NO_MONITOR, comparator, EncodingIdMapperTest.autoDetect((Encoder)encoder), nThreads);
        int count = nThreads * 1000;
        MutableLong nextNodeId = new MutableLong();
        for (long id = 0L; id < (long)count; ++id) {
            idMapper.put((Object)id, nextNodeId.getAndAdd((long)this.random.nextInt(50, 100)), this.globalGroup);
        }
        idMapper.prepare(nodeId -> {
            throw new RuntimeException();
        }, Collector.EMPTY, ProgressListener.NONE);
        Assertions.assertThat((int)numberOfComparisons.get()).isLessThan(nextNodeId.intValue() / 4);
    }

    @Test
    void shouldHandleEqualIdsInMultipleGroups() {
        IdMapper idMapper = this.mapper((Encoder)new StringEncoder(), (Factory<Radix>)Radix.STRING, EncodingIdMapper.NO_MONITOR, 1);
        Groups groups = new Groups();
        Group movie = groups.getOrCreate("Movie");
        Group actor = groups.getOrCreate("Actor");
        idMapper.put((Object)"1", 546L, actor);
        idMapper.put((Object)"1", 0L, movie);
        idMapper.put((Object)"2", 547L, actor);
        idMapper.put((Object)"2", 1L, movie);
        idMapper.put((Object)"3", 548L, actor);
        idMapper.put((Object)"3", 2L, movie);
        idMapper.prepare(null, Collector.EMPTY, ProgressListener.NONE);
        Assertions.assertThat((long)idMapper.get((Object)"1", actor)).isEqualTo(546L);
        Assertions.assertThat((long)idMapper.get((Object)"1", movie)).isEqualTo(0L);
        Assertions.assertThat((long)idMapper.get((Object)"2", actor)).isEqualTo(547L);
        Assertions.assertThat((long)idMapper.get((Object)"2", movie)).isEqualTo(1L);
        Assertions.assertThat((long)idMapper.get((Object)"3", actor)).isEqualTo(548L);
        Assertions.assertThat((long)idMapper.get((Object)"3", movie)).isEqualTo(2L);
    }

    private static PropertyValueLookup values(Object ... values) {
        return value -> values[Math.toIntExact(value)];
    }

    private IdMapper mapper(Encoder encoder, Factory<Radix> radix, EncodingIdMapper.Monitor monitor, int processors) {
        return new EncodingIdMapper(NumberArrayFactories.HEAP, encoder, radix, monitor, RANDOM_TRACKER_FACTORY, (ReadableGroups)this.groups, EncodingIdMapperTest.autoDetect(encoder), 10000, processors, ParallelSort.DEFAULT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private EncodingIdMapper mapper(Encoder encoder, Factory<Radix> radix, EncodingIdMapper.Monitor monitor, ParallelSort.Comparator comparator, LongFunction<CollisionValues> collisionValuesFactory, int processors) {
        return new EncodingIdMapper(NumberArrayFactories.HEAP, encoder, radix, monitor, RANDOM_TRACKER_FACTORY, (ReadableGroups)this.groups, collisionValuesFactory, 1000, processors, comparator, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private static LongFunction<CollisionValues> autoDetect(Encoder encoder) {
        return numberOfCollisions -> encoder instanceof LongEncoder ? new LongCollisionValues(NumberArrayFactories.HEAP, numberOfCollisions, (MemoryTracker)EmptyMemoryTracker.INSTANCE) : new StringCollisionValues(NumberArrayFactories.HEAP, numberOfCollisions, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ValueType {
        LONGS{

            @Override
            Encoder encoder() {
                return new LongEncoder();
            }

            @Override
            Factory<Radix> radix() {
                return Radix.LONG;
            }

            @Override
            Factory<Object> data(Random random) {
                return () -> random.nextInt(1000000000);
            }
        }
        ,
        LONGS_AS_STRINGS{

            @Override
            Encoder encoder() {
                return new StringEncoder();
            }

            @Override
            Factory<Radix> radix() {
                return Radix.STRING;
            }

            @Override
            Factory<Object> data(Random random) {
                return () -> String.valueOf(random.nextInt(1000000000));
            }
        }
        ,
        VERY_LONG_STRINGS{
            final char[] CHARS = "\u00bd!\"#\u00a4%&/()=?`\u00b4;:,._-<>".toCharArray();

            @Override
            Encoder encoder() {
                return new StringEncoder();
            }

            @Override
            Factory<Radix> radix() {
                return Radix.STRING;
            }

            @Override
            Factory<Object> data(final Random random) {
                return new Factory<Object>(){

                    public Object newInstance() {
                        int length = 1500;
                        for (int i = 0; i < 4; ++i) {
                            length = random.nextInt(length) + 20;
                        }
                        char[] chars = new char[length];
                        for (int i = 0; i < length; ++i) {
                            char ch = random.nextBoolean() ? this.randomLetter(random) : CHARS[random.nextInt(CHARS.length)];
                            chars[i] = ch;
                        }
                        return new String(chars);
                    }

                    private char randomLetter(Random random2) {
                        int base = random2.nextBoolean() ? 97 : 65;
                        int size = 25;
                        return (char)(base + random2.nextInt(size));
                    }
                };
            }
        };


        abstract Encoder encoder();

        abstract Factory<Radix> radix();

        abstract Factory<Object> data(Random var1);
    }

    private static class ValueGenerator
    implements PropertyValueLookup {
        private final Factory<Object> generator;
        private final List<Object> values = new ArrayList<Object>();
        private final Set<Object> deduper = new HashSet<Object>();

        ValueGenerator(Factory<Object> generator) {
            this.generator = generator;
        }

        public Object lookupProperty(long nodeId) {
            Object value;
            while (!this.deduper.add(value = this.generator.newInstance())) {
            }
            this.values.add(value);
            return value;
        }
    }

    private static class CountingCollector
    implements Collector {
        private int count;

        private CountingCollector() {
        }

        public void collectBadRelationship(Object startId, Group startIdGroup, String type, Object endId, Group endIdGroup, Object specificValue) {
            throw new UnsupportedOperationException();
        }

        public void collectDuplicateNode(Object id, long actualId, Group group) {
            ++this.count;
        }

        public boolean isCollectingBadRelationships() {
            return false;
        }

        public void collectExtraColumns(String source, long row, String value) {
            throw new UnsupportedOperationException();
        }

        public void collectNodeViolatingConstraint(Object id, long actualId, Map<String, Object> properties, String constraintDescription) {
            throw new UnsupportedOperationException();
        }

        public long badEntries() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }
}

