/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.string.GroupCache;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class GroupCacheTest {
    GroupCacheTest() {
    }

    @Test
    void shouldHandleSingleByteCount() {
        int max = 256;
        GroupCache cache = GroupCache.select((NumberArrayFactory)NumberArrayFactories.HEAP, (int)100, (int)max, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        GroupCacheTest.assertSetAndGet(cache, 10L, 45);
        GroupCacheTest.assertSetAndGet(cache, 100L, 145);
        GroupCacheTest.assertSetAndGet(cache, 1000L, 245);
        Assertions.assertThrows(ArithmeticException.class, () -> cache.set(10000L, 345));
    }

    @Test
    void shouldSwitchToTwoByteVersionBeyondSingleByteGroupIds() {
        int max = 257;
        GroupCache cache = GroupCache.select((NumberArrayFactory)NumberArrayFactories.HEAP, (int)100, (int)max, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        GroupCacheTest.assertSetAndGet(cache, 10L, 123);
        GroupCacheTest.assertSetAndGet(cache, 100L, 1234);
        GroupCacheTest.assertSetAndGet(cache, 1000L, 12345);
        GroupCacheTest.assertSetAndGet(cache, 10000L, 65535);
        Assertions.assertThrows(ArithmeticException.class, () -> cache.set(100000L, 123456));
    }

    private static void assertSetAndGet(GroupCache cache, long nodeId, int groupId) {
        cache.set(nodeId, groupId);
    }
}

