/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.Arrays;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.string.LongCollisionValues;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class LongCollisionValuesTest {
    @Inject
    private RandomSupport random;

    LongCollisionValuesTest() {
    }

    static Collection<NumberArrayFactory> data() {
        return Arrays.asList(NumberArrayFactories.HEAP, NumberArrayFactories.OFF_HEAP, NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, NumberArrayFactories.CHUNKED_FIXED_SIZE);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void shouldStoreAndLoadLongs(NumberArrayFactory factory) {
        try (LongCollisionValues values = new LongCollisionValues(factory, 100L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            int i;
            long[] offsets = new long[100];
            long[] longs = new long[offsets.length];
            for (i = 0; i < offsets.length; ++i) {
                long value = this.random.nextLong(Long.MAX_VALUE);
                offsets[i] = values.add((Object)value);
                longs[i] = value;
            }
            for (i = 0; i < offsets.length; ++i) {
                Assertions.assertEquals((long)longs[i], (long)((Long)values.get(offsets[i])));
            }
        }
    }
}

