/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.internal.batchimport.cache.idmapping.string.LongEncoder;

class LongEncoderTest {
    LongEncoderTest() {
    }

    @Test
    void shouldProperlyEncodeLength() {
        LongEncoder encoder = new LongEncoder();
        long a = encoder.encode((Object)0x2000000L);
        long b = encoder.encode((Object)0x10000000L);
        Assertions.assertNotEquals((long)a, (long)b);
    }

    @Test
    void shouldThrowOnEncodingTooLargeID() {
        LongEncoder encoder = new LongEncoder();
        long invalidValue = 120402172287879439L;
        Assertions.assertThrows(IllegalArgumentException.class, () -> LongEncoderTest.lambda$shouldThrowOnEncodingTooLargeID$0((Encoder)encoder, invalidValue));
    }

    @Test
    void shouldThrowOnEncodingNegativeID() {
        LongEncoder encoder = new LongEncoder();
        long invalidValue = -1L;
        Assertions.assertThrows(IllegalArgumentException.class, () -> LongEncoderTest.lambda$shouldThrowOnEncodingNegativeID$1((Encoder)encoder, invalidValue));
    }

    private static /* synthetic */ void lambda$shouldThrowOnEncodingNegativeID$1(Encoder encoder, long invalidValue) throws Throwable {
        encoder.encode((Object)invalidValue);
    }

    private static /* synthetic */ void lambda$shouldThrowOnEncodingTooLargeID$0(Encoder encoder, long invalidValue) throws Throwable {
        encoder.encode((Object)invalidValue);
    }
}

