/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.batchimport.cache.idmapping.string.Radix;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class RadixTest {
    @Inject
    private RandomSupport random;

    RadixTest() {
    }

    @Test
    void shouldHandleCountsLargerThanInt() {
        Radix radix = (Radix)Radix.LONG.newInstance();
        long value = this.random.nextLong(0xFFFFFFFFFFFFL);
        long count = 0x100000000L;
        for (long i = 0L; i < count; ++i) {
            radix.registerRadixOf(value);
        }
        Assertions.assertThat((long)LongStream.of(radix.radixIndexCount).sum()).isEqualTo(count);
    }

    @Test
    void shouldKeepNullValuesInSeparateCounter() {
        Radix radix = (Radix)Radix.LONG.newInstance();
        long nullValue = 0L;
        int expectedNumNullValues = 0;
        for (int i = 0; i < 100; ++i) {
            boolean realValue = this.random.nextBoolean();
            radix.registerRadixOf(realValue ? this.random.nextLong(1L, 10000L) : nullValue);
            if (realValue) continue;
            ++expectedNumNullValues;
        }
        Assertions.assertThat((long)radix.getNullCount()).isEqualTo((long)expectedNumNullValues);
    }
}

