/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache.idmapping.string;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.PageCachedNumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.string.StringCollisionValues;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.RandomValues;

@PageCacheExtension
class StringCollisionValuesTest {
    @RegisterExtension
    static final RandomExtension randomExtension = new RandomExtension(new RandomValues.Default(){

        public int stringMaxLength() {
            return 65535;
        }
    });
    @Inject
    private RandomSupport random;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private PageCache pageCache;

    StringCollisionValuesTest() {
    }

    private static Stream<BiFunction<PageCache, Path, NumberArrayFactory>> data() {
        return Stream.of((pageCache, homePath) -> NumberArrayFactories.HEAP, (pageCache, homePath) -> NumberArrayFactories.OFF_HEAP, (pageCache, homePath) -> NumberArrayFactories.AUTO_WITHOUT_PAGECACHE, (pageCache, homePath) -> NumberArrayFactories.CHUNKED_FIXED_SIZE, (pageCache, homePath) -> new PageCachedNumberArrayFactory(pageCache, new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY), homePath, (InternalLog)NullLog.getInstance(), "neo4j"));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void shouldStoreAndLoadStrings(BiFunction<PageCache, Path, NumberArrayFactory> factory) {
        try (StringCollisionValues values = new StringCollisionValues(factory.apply(this.pageCache, this.testDirectory.homePath()), 10000L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            int i;
            long[] offsets = new long[100];
            String[] strings = new String[offsets.length];
            for (i = 0; i < offsets.length; ++i) {
                String string = this.random.nextAlphaNumericString();
                offsets[i] = values.add((Object)string);
                strings[i] = string;
            }
            for (i = 0; i < offsets.length; ++i) {
                Assertions.assertEquals((Object)strings[i], (Object)values.get(offsets[i]));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void shouldMoveOverToNextChunkOnNearEnd(BiFunction<PageCache, Path, NumberArrayFactory> factory) {
        try (StringCollisionValues values = new StringCollisionValues(factory.apply(this.pageCache, this.testDirectory.homePath()), 10000L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            char[] chars = new char[8189];
            Arrays.fill(chars, 'a');
            String string = String.valueOf(chars);
            long offset = values.add((Object)string);
            String secondString = "abcdef";
            long secondOffset = values.add((Object)secondString);
            String readString = (String)values.get(offset);
            Assertions.assertEquals((Object)string, (Object)readString);
            String readSecondString = (String)values.get(secondOffset);
            Assertions.assertEquals((Object)secondString, (Object)readSecondString);
        }
    }
}

